/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.core;

import com.xunlei.channel.common.http.annotation.ParamAttr;
import com.xunlei.channel.common.http.core.ApiAttr;
import com.xunlei.channel.common.http.core.RequestDataProcessor;
import com.xunlei.channel.common.http.core.RequestMetaData;
import com.xunlei.channel.common.http.object.AbstractRequestObject;
import com.xunlei.channel.common.http.utils.FieldUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.stream.Stream;

public class RequestDataWrapper {
    public static RequestMetaData wrapRequestData(ApiAttr apiAttr, AbstractRequestObject object) {
        Field[] fields = object.getClass().getDeclaredFields();
        if (fields.length < apiAttr.getApiParams().size()) {
            throw new IllegalArgumentException("fields size smaller than api params!");
        }
        Object[] arr = Stream.of(fields).map(f -> {
            f.setAccessible(true);
            try {
                return f.get(object);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).toArray();
        RequestDataProcessor processor = apiAttr.getProcessor();
        return processor == null ? RequestDataWrapper.doWrap(arr, apiAttr).signIfNecessary(apiAttr.getSignInfo()) : processor.process(RequestDataWrapper.doWrap(arr, apiAttr).signIfNecessary(apiAttr.getSignInfo()));
    }

    public static RequestMetaData wrapRequestData(ApiAttr apiAttr, Object[] parameters) {
        if (parameters.length < apiAttr.getApiParams().size()) {
            throw new IllegalArgumentException("parameter size smaller than api params!");
        }
        RequestDataProcessor processor = apiAttr.getProcessor();
        return processor == null ? RequestDataWrapper.doWrap(parameters, apiAttr).signIfNecessary(apiAttr.getSignInfo()) : processor.process(RequestDataWrapper.doWrap(parameters, apiAttr).signIfNecessary(apiAttr.getSignInfo()));
    }

    private static RequestMetaData doWrap(Object[] arr, ApiAttr apiAttr) {
        HashMap<String, String> json = new HashMap<String, String>();
        HashMap<String, String> url = new HashMap<String, String>();
        HashMap<String, String> path = new HashMap<String, String>();
        File file = null;
        String fileName = null;
        for (ApiAttr.ApiParam param : apiAttr.getApiParams()) {
            Object o = arr[param.getIndex()];
            if (o == null) {
                if (!param.isNotnull()) continue;
                throw new IllegalArgumentException(param.getKey() + "can't be null");
            }
            if (param.getLocation() == ParamAttr.Location.QUERY_STRING) {
                url.put(param.getKey(), FieldUtils.toStringValue(o));
                continue;
            }
            if (param.getLocation() == ParamAttr.Location.REQUEST_BODY) {
                json.put(param.getKey(), FieldUtils.toStringValue(o));
                continue;
            }
            if (param.getLocation() == ParamAttr.Location.FILE) {
                if (o instanceof File) {
                    file = (File)o;
                    fileName = param.getKey();
                    continue;
                }
                throw new RuntimeException("File location must be file type");
            }
            if (param.getLocation() != ParamAttr.Location.PATH) continue;
            if (!FieldUtils.isPrimitive(o.getClass())) {
                throw new RuntimeException("can't write path {" + param.getKey() + "}path value must be primitive");
            }
            path.put(param.getKey(), FieldUtils.toStringValue(o));
        }
        if (apiAttr.getImplicateValues() != null) {
            if (apiAttr.getImplicateValues().getLocation() == ParamAttr.Location.REQUEST_BODY) {
                json.putAll(apiAttr.getImplicateValues().getValues());
            } else if (apiAttr.getImplicateValues().getLocation() == ParamAttr.Location.QUERY_STRING) {
                url.putAll(apiAttr.getImplicateValues().getValues());
            }
        }
        return new RequestMetaData(apiAttr.getUrl(), path, json, url, file, fileName, apiAttr.getRequestBodyFormat());
    }
}

