/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.core;

import com.xunlei.channel.common.http.annotation.Format;
import com.xunlei.channel.common.http.core.RequestMetaData;
import com.xunlei.channel.common.http.utils.JSON;
import com.xunlei.channel.common.http.utils.RequestType;
import com.xunlei.channel.common.http.utils.StringUtils;
import com.xunlei.channel.common.http.utils.URLFactory;
import com.xunlei.channel.common.http.utils.XML;
import java.io.File;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBuilder {
    private static Logger logger = LoggerFactory.getLogger(RequestBuilder.class);

    public static Request build(RequestMetaData requestMetaData) {
        String baseUrl = URLFactory.createURL(requestMetaData.getRawURL(), requestMetaData.getPaths());
        String fullURL = baseUrl + "?" + StringUtils.toURLString(requestMetaData.getParams());
        logger.debug("request url#{}", (Object)fullURL);
        Request.Builder builder = new Request.Builder().url(fullURL);
        RequestBody body = null;
        if (requestMetaData.getBody().size() != 0) {
            if (requestMetaData.getFormat().format() == Format.DataFormat.JSON) {
                body = RequestBody.create((MediaType)RequestType.JSON_CONTENT, (String)JSON.toJSONString(requestMetaData.getBody(), requestMetaData.getFormat().root()));
            } else if (requestMetaData.getFormat().format() == Format.DataFormat.XML) {
                body = RequestBody.create((MediaType)RequestType.XML_CONTENT, (String)XML.toXMLString(requestMetaData.getBody(), requestMetaData.getFormat().root()));
            } else if (requestMetaData.getFormat().format() == Format.DataFormat.FORM) {
                MultipartBody.Builder b = new MultipartBody.Builder().setType(MultipartBody.FORM);
                for (Map.Entry<String, String> form : requestMetaData.getBody().entrySet()) {
                    b.addFormDataPart(form.getKey(), form.getValue());
                }
                body = b.build();
            }
        }
        if (requestMetaData.getFile() != null) {
            body = body != null ? new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(requestMetaData.getFileName(), requestMetaData.getFile().getName(), RequestBody.create((MediaType)RequestType.MEDIA_CONTENT, (File)requestMetaData.getFile())).addPart(body).build() : new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(requestMetaData.getFileName(), requestMetaData.getFile().getName(), RequestBody.create((MediaType)RequestType.MEDIA_CONTENT, (File)requestMetaData.getFile())).build();
        }
        if (body != null) {
            builder.post(body);
        }
        return builder.build();
    }
}

