/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.core;

import com.xunlei.channel.common.http.core.Client;
import com.xunlei.channel.common.http.core.CustomTrust;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
implements Client {
    private static OkHttpClient client = new OkHttpClient();
    private static Logger logger = LoggerFactory.getLogger(DefaultClient.class);

    @Override
    public Optional<Response> sendRequest(Request request) {
        try {
            return Optional.ofNullable(client.newCall(request).execute());
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Client auth(String user, String password) {
        String cre = Credentials.basic((String)user, (String)password);
        client = client.newBuilder().authenticator((r, rs) -> rs.request().newBuilder().header("Authorization", cre).build()).build();
        return this;
    }

    @Override
    public Client readTimeout(long amount, TimeUnit unit) {
        client = client.newBuilder().readTimeout(amount, unit).build();
        return this;
    }

    @Override
    public Client writeTimeout(long amount, TimeUnit unit) {
        client = client.newBuilder().writeTimeout(amount, unit).build();
        return this;
    }

    @Override
    public Client customTrust(CustomTrust customTrust) {
        client = client.newBuilder().sslSocketFactory(customTrust.getSslSocketFactory(), customTrust.getTrustManager()).build();
        return this;
    }
}

