/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CustomTrust {
    private X509TrustManager trustManager;
    private SSLSocketFactory sslSocketFactory;
    public static final CustomTrust TRUST_ALL;

    public CustomTrust(X509TrustManager trustManager, SSLSocketFactory sslSocketFactory) {
        this.trustManager = trustManager;
        this.sslSocketFactory = sslSocketFactory;
    }

    public CustomTrust(String[] files) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (String file : files) {
            File f = new File(file);
            try {
                int i;
                FileInputStream inputStream = new FileInputStream(f);
                byte[] buffer = new byte[1024];
                while ((i = ((InputStream)inputStream).read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, i);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.createFromInputStream(inputStream);
    }

    public CustomTrust(String in) {
        this.createFromInputStream(new ByteArrayInputStream(in.getBytes()));
    }

    public CustomTrust(InputStream in) {
        this.createFromInputStream(in);
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    private void createFromInputStream(InputStream in) {
        try {
            this.trustManager = this.trustManagerForCertificates(in);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.trustManager}, null);
            this.sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public X509TrustManager trustManagerForCertificates(InputStream in) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
            if (certificates.isEmpty()) {
                throw new IllegalArgumentException("expected non-empty set of trusted certificates");
            }
            char[] password = "password".toCharArray();
            KeyStore keyStore = this.newEmptyKeyStore(password);
            int index = 0;
            for (Certificate certificate : certificates) {
                String certificateAlias = Integer.toString(index++);
                keyStore.setCertificateEntry(certificateAlias, certificate);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream in = null;
            keyStore.load(in, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            X509TrustManager empty = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{empty}, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            TRUST_ALL = new CustomTrust(empty, sslSocketFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

