/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.http.core;

import com.xunlei.channel.common.http.annotation.API;
import com.xunlei.channel.common.http.annotation.Format;
import com.xunlei.channel.common.http.annotation.ImplicateValues;
import com.xunlei.channel.common.http.annotation.NotNull;
import com.xunlei.channel.common.http.annotation.ParamAttr;
import com.xunlei.channel.common.http.annotation.Sign;
import com.xunlei.channel.common.http.core.ApiAttr;
import com.xunlei.channel.common.http.object.AbstractRequestObject;
import com.xunlei.channel.common.http.object.FormBodyRequestObject;
import com.xunlei.channel.common.http.object.JSONBodyRequestObject;
import com.xunlei.channel.common.http.object.PostBodyRequestObject;
import com.xunlei.channel.common.http.object.QueryStringRequestObject;
import com.xunlei.channel.common.http.object.RequestObject;
import com.xunlei.channel.common.http.object.XMLBodyRequestObject;
import com.xunlei.channel.common.http.service.ServiceInitException;
import com.xunlei.channel.config.annotation.ConfigValue;
import com.xunlei.channel.config.core.BaseKV;
import com.xunlei.channel.config.support.ConfigSupport;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiAttrCreator {
    private static Logger logger = LoggerFactory.getLogger(ApiAttrCreator.class);

    public static ApiAttr createApiAttr(AbstractRequestObject requestObject) {
        Class<?> apiClazz = requestObject.getClass();
        API config = apiClazz.getAnnotation(API.class);
        String url = (String)ConfigSupport.extractConfigValue((ConfigValue)config.api()).val();
        Class type = (Class)((ParameterizedType)apiClazz.getGenericSuperclass()).getActualTypeArguments()[0];
        ApiAttr.ReturnClass returnClass = ApiAttrCreator.getReturnClass(type);
        ApiAttr.ImplicateValues values = ApiAttrCreator.getImplicateValues(apiClazz.getAnnotation(ImplicateValues.class));
        Sign sign = apiClazz.getAnnotation(Sign.class);
        List<ApiAttr.ApiParam> list = ApiAttrCreator.getApiParamList(apiClazz);
        Format format = apiClazz.getAnnotation(Format.class);
        if (format == null) {
            format = requestObject instanceof FormBodyRequestObject ? Format.FORM : (requestObject instanceof JSONBodyRequestObject ? Format.JSON : (requestObject instanceof XMLBodyRequestObject ? Format.XML : Format.DEFAULT));
        }
        return new ApiAttr(url, list, returnClass, values, sign, format, requestObject.getSpecialDataProcessor());
    }

    public static ApiAttr createApiAttr(Method apiMethod) {
        API config = apiMethod.getAnnotation(API.class);
        String url = (String)ConfigSupport.extractConfigValue((ConfigValue)config.api()).val();
        Type type = apiMethod.getGenericReturnType();
        ApiAttr.ReturnClass returnClass = ApiAttrCreator.getReturnClass(type);
        ApiAttr.ImplicateValues values = ApiAttrCreator.getImplicateValues(apiMethod.getAnnotation(ImplicateValues.class));
        Sign sign = apiMethod.getAnnotation(Sign.class);
        List<ApiAttr.ApiParam> list = ApiAttrCreator.getApiParamList(apiMethod);
        Format format = apiMethod.getAnnotation(Format.class) == null ? Format.DEFAULT : apiMethod.getAnnotation(Format.class);
        return new ApiAttr(url, list, returnClass, values, sign, format, null);
    }

    private static List<ApiAttr.ApiParam> getApiParamList(Method apiMethod) {
        int fileParamTotal = 0;
        LinkedList<ApiAttr.ApiParam> list = new LinkedList<ApiAttr.ApiParam>();
        Parameter[] parameters = apiMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            String key;
            ParamAttr.Location location;
            Parameter parameter = parameters[i];
            ParamAttr paramAttr = parameter.getAnnotation(ParamAttr.class);
            NotNull notNull = parameter.getAnnotation(NotNull.class);
            if (paramAttr == null) {
                logger.debug("use default config with parameter#{} in method#{}", (Object)parameter.getName(), (Object)apiMethod.getName());
                location = ParamAttr.DEFAULT_LOCATION;
                key = parameter.getName();
            } else {
                key = paramAttr.paramKey();
                location = paramAttr.location();
            }
            ApiAttr.ApiParam apiParam = new ApiAttr.ApiParam(i, location, key, notNull != null);
            if (location == ParamAttr.Location.FILE) {
                ++fileParamTotal;
                if (File.class != apiMethod.getParameterTypes()[i]) {
                    throw new ServiceInitException("File location must be file type");
                }
            }
            if (fileParamTotal > 1) {
                throw new ServiceInitException("only one file type");
            }
            list.add(apiParam);
        }
        return list;
    }

    private static List<ApiAttr.ApiParam> getApiParamList(Class<? extends RequestObject> apiObject) {
        int fileParamTotal = 0;
        ApiAttr.ApiParam apiParam = null;
        LinkedList<ApiAttr.ApiParam> list = new LinkedList<ApiAttr.ApiParam>();
        Field[] fields = apiObject.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            ParamAttr attr = field.getAnnotation(ParamAttr.class);
            NotNull notNull = field.getAnnotation(NotNull.class);
            if (attr != null) {
                apiParam = new ApiAttr.ApiParam(i, attr.location(), attr.paramKey(), notNull != null);
                if (attr.location() == ParamAttr.Location.FILE) {
                    ++fileParamTotal;
                    if (File.class != field.getType()) {
                        throw new ServiceInitException("File location must be file type");
                    }
                    if (fileParamTotal > 1) {
                        throw new ServiceInitException("only one file type");
                    }
                }
            } else if (QueryStringRequestObject.class.isAssignableFrom(apiObject)) {
                apiParam = new ApiAttr.ApiParam(i, ParamAttr.Location.QUERY_STRING, field.getName(), notNull != null);
            } else if (PostBodyRequestObject.class.isAssignableFrom(apiObject)) {
                apiParam = new ApiAttr.ApiParam(i, ParamAttr.Location.REQUEST_BODY, field.getName(), notNull != null);
            } else if (XMLBodyRequestObject.class.isAssignableFrom(apiObject)) {
                apiParam = new ApiAttr.ApiParam(i, ParamAttr.Location.REQUEST_BODY, field.getName(), notNull != null);
            }
            if (apiParam == null) continue;
            list.add(apiParam);
        }
        return list;
    }

    private static ApiAttr.ImplicateValues getImplicateValues(ImplicateValues values) {
        ApiAttr.ImplicateValues v = null;
        if (values != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Arrays.stream(values.values()).forEach(c -> {
                BaseKV kv = ConfigSupport.extractConfigValue((ConfigValue)c);
                hashMap.put(kv.key(), (String)kv.val());
            });
            v = new ApiAttr.ImplicateValues(hashMap, values.location());
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ApiAttr.ReturnClass getReturnClass(Type genericReturnType) {
        Class real;
        boolean isOptional;
        boolean isList;
        if (ParameterizedType.class.isAssignableFrom(genericReturnType.getClass())) {
            Type rawType = ((ParameterizedType)genericReturnType).getRawType();
            if (List.class.equals((Object)rawType)) {
                isList = true;
                isOptional = false;
                Type argumentsType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                real = (Class)argumentsType;
                return new ApiAttr.ReturnClass(isList, isOptional, real.getAnnotation(Format.class), real);
            } else {
                if (!Optional.class.equals((Object)rawType)) throw new RuntimeException("unsupported genericReturnType!");
                isOptional = true;
                Type inner = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                if (ParameterizedType.class.isAssignableFrom(inner.getClass())) {
                    if (!List.class.equals((Object)((ParameterizedType)inner).getRawType())) throw new RuntimeException("only support list container");
                    isList = true;
                    Type argumentsType = ((ParameterizedType)inner).getActualTypeArguments()[0];
                    real = (Class)argumentsType;
                    return new ApiAttr.ReturnClass(isList, isOptional, real.getAnnotation(Format.class), real);
                } else {
                    isList = false;
                    Type argumentsType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                    real = (Class)argumentsType;
                }
            }
            return new ApiAttr.ReturnClass(isList, isOptional, real.getAnnotation(Format.class), real);
        } else {
            isList = false;
            isOptional = false;
            real = (Class)genericReturnType;
        }
        return new ApiAttr.ReturnClass(isList, isOptional, real.getAnnotation(Format.class), real);
    }
}

