/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.task.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.engine.AlarmEngine;
import com.xunlei.channel.alarmcenter.provider.DataProvider;
import com.xunlei.channel.alarmcenter.task.AlarmTask;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AlarmTaskImpl
implements AlarmTask {
    private static final Logger logger = LoggerFactory.getLogger(AlarmTaskImpl.class);
    public static final int MAX_FETCH_DATA_SIZE = 50;
    @Autowired
    private AlarmEngine alarmEngine;
    @Autowired
    private DataProvider dataProvider;

    public void execute() {
        List<AlarmData> alarmDataList = this.dataProvider.loadData(50);
        if (CollectionUtils.isEmpty(alarmDataList)) {
            logger.debug("nothing to alarm...");
            return;
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("fetch alarmData: {}", (Object)new ObjectMapper().writeValueAsString(alarmDataList));
            }
            catch (JsonProcessingException ignored) {
                // empty catch block
            }
        }
        ArrayList<AlarmData> alarmedDataList = new ArrayList<AlarmData>();
        for (AlarmData alarmData : alarmDataList) {
            try {
                boolean alarmed = this.alarmEngine.alarm(alarmData);
                if (logger.isInfoEnabled()) {
                    logger.info("alarm data: {}, alarmed result: {}", (Object)alarmData, (Object)alarmed);
                }
                if (!alarmed) continue;
                alarmedDataList.add(alarmData);
            }
            catch (Exception e) {
                try {
                    logger.error("alarm data: " + new ObjectMapper().writeValueAsString((Object)alarmData) + " error with message: " + e.getMessage(), (Throwable)e);
                }
                catch (JsonProcessingException ignored) {}
            }
        }
        try {
            this.dataProvider.alarmedData(alarmedDataList);
        }
        catch (Exception e) {
            logger.error("mark alarm data as alarmed error with message: " + e.getMessage(), (Throwable)e);
        }
        try {
            boolean b = alarmDataList.removeAll(alarmedDataList);
            if (b) {
                this.dataProvider.notAlarmedData(alarmDataList);
            }
        }
        catch (Exception e) {
            logger.error("mark alarm data as not alarmed error with message: " + e.getMessage(), (Throwable)e);
        }
    }
}

