/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.receive.service.impl;

import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmDataDAO;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmReceiveResult;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmRequest;
import com.xunlei.channel.alarmcenter.receive.service.AlarmService;
import com.xunlei.channel.alarmcenter.receive.util.AlarmReceiveResultBuilder;
import com.xunlei.xlcommons.util.MD5.Md5Encrypt;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class AlarmServiceImpl
implements AlarmService {
    @Autowired
    AlarmDataDAO alarmDataDAO;
    private static final Logger logger = LoggerFactory.getLogger(AlarmServiceImpl.class);
    private static final String CHARSET = "UTF-8";

    @Override
    public AlarmReceiveResult receiveAlarmRequest(AlarmRequest request, HttpServletRequest httpServletRequest) {
        AlarmReceiveResult validateResult = AlarmReceiveResultBuilder.validateParams(request);
        if (validateResult != null) {
            return validateResult;
        }
        try {
            this.saveAlarmData(request, httpServletRequest);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return new AlarmReceiveResult("99", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return new AlarmReceiveResult("00", "");
    }

    private void saveAlarmData(AlarmRequest request, HttpServletRequest httpServletRequest) throws DataAccessException {
        AlarmData alarmData = new AlarmData();
        alarmData.setAlarmId(request.getAlarmId());
        alarmData.setContent(request.getContent());
        alarmData.setExtraJson(request.getExtraJson());
        alarmData.setGroupId(request.getGroupId());
        alarmData.setSignature(Md5Encrypt.encode((String)request.getContent(), (String)CHARSET));
        this.alarmDataDAO.saveAlarmData(alarmData);
    }
}

