/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.interf.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.dbservice.dao.ContactDAO;
import com.xunlei.channel.alarmcenter.dbservice.pojo.Contact;
import com.xunlei.channel.alarmcenter.interf.controller.AbstractAlarmController;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmReceiveResult;
import com.xunlei.channel.alarmcenter.receive.pojo.ContactRequest;
import com.xunlei.channel.alarmcenter.receive.util.AlarmReceiveResultBuilder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ContactsController
extends AbstractAlarmController {
    private static final Logger logger = LoggerFactory.getLogger(ContactsController.class);
    @Autowired
    private ContactDAO contactDAO;

    @RequestMapping(value={"/contacts/request"}, produces={"application/xml"})
    public ModelAndView addContact(ContactRequest request, HttpServletRequest httpServletRequest) {
        logger.info("addAlarmItem...queryString:{}", (Object)httpServletRequest.getQueryString());
        AlarmReceiveResult alarmReceiveResult = AlarmReceiveResultBuilder.validateParams((Object)request);
        if (alarmReceiveResult != null) {
            return this.generateXmlModelAndView(alarmReceiveResult);
        }
        this.contactDAO.saveContact((Contact)request);
        return this.generateXmlModelAndView(AlarmReceiveResultBuilder.success());
    }

    @RequestMapping(value={"/contacts/list"}, produces={"application/xml"})
    public ModelAndView listContacts(ContactRequest request, HttpServletRequest httpServletRequest) {
        if (request == null) {
            request = new ContactRequest();
        }
        List contactList = this.contactDAO.findContact((Contact)request);
        try {
            logger.info("listContacts... queryString: {}, response: {}", (Object)httpServletRequest.getQueryString(), (Object)((ObjectMapper)this.mapper.get()).writeValueAsString((Object)contactList));
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return this.generateJsonModelAndView(contactList);
    }

    @RequestMapping(value={"/contacts/update"}, produces={"application/xml"})
    public ModelAndView updateContact(ContactRequest request, HttpServletRequest httpServletRequest) {
        logger.info("addAlarmItem...queryString:{}", (Object)httpServletRequest.getQueryString());
        Long id = request.getId();
        if (id == null) {
            AlarmReceiveResult receiveResult = new AlarmReceiveResult("13", "contact id could not be null!");
            return this.generateXmlModelAndView(receiveResult);
        }
        this.contactDAO.updateContact((Contact)request);
        return this.generateXmlModelAndView(AlarmReceiveResultBuilder.success());
    }
}

