/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.interf.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmDataDAO;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.interf.controller.AbstractAlarmController;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmReceiveResult;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmRequest;
import com.xunlei.channel.alarmcenter.receive.service.AlarmService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AlarmRequestController
extends AbstractAlarmController {
    private static final Logger logger = LoggerFactory.getLogger(AlarmRequestController.class);
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private AlarmDataDAO alarmDataDAO;

    @RequestMapping(value={"/alarm/request"}, produces={"application/xml"})
    public ModelAndView alarmRequestByXml(AlarmRequest alarmRequest, HttpServletRequest httpServletRequest) {
        logger.info("alarmRequestByXml...queryString:{}", (Object)httpServletRequest.getQueryString());
        AlarmReceiveResult result = this.alarmService.receiveAlarmRequest(alarmRequest, httpServletRequest);
        return this.generateXmlModelAndView(result);
    }

    @RequestMapping(value={"/alarm/list"}, produces={"application/json"})
    public ModelAndView listAlarmData(AlarmData alarmData, HttpServletRequest httpServletRequest) {
        if (alarmData == null) {
            alarmData = new AlarmData();
        }
        List alarmDataList = this.alarmDataDAO.findAlarmData(alarmData);
        try {
            logger.info("listAlarmData... queryString: {}, response: {}", (Object)httpServletRequest.getQueryString(), (Object)((ObjectMapper)this.mapper.get()).writeValueAsString((Object)alarmDataList));
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return this.generateJsonModelAndView(alarmDataList);
    }
}

