/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.interf.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmItemDAO;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.engine.AlarmEngine;
import com.xunlei.channel.alarmcenter.interf.controller.AbstractAlarmController;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmItemRequest;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmReceiveResult;
import com.xunlei.channel.alarmcenter.receive.util.AlarmReceiveResultBuilder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AlarmItemController
extends AbstractAlarmController {
    private static final Logger logger = LoggerFactory.getLogger(AlarmItemController.class);
    @Autowired
    private AlarmItemDAO alarmItemDAO;
    @Autowired
    private AlarmEngine alarmEngine;

    @RequestMapping(value={"/alarmItem/request"}, produces={"application/xml"})
    public ModelAndView addAlarmItem(AlarmItemRequest request, HttpServletRequest httpServletRequest) {
        logger.info("addAlarmItem...queryString:{}", (Object)httpServletRequest.getQueryString());
        AlarmReceiveResult alarmReceiveResult = AlarmReceiveResultBuilder.validateParams((Object)request);
        if (alarmReceiveResult != null) {
            return this.generateXmlModelAndView(alarmReceiveResult);
        }
        try {
            boolean validate = this.alarmEngine.validate((AlarmItem)request);
            if (!validate) {
                AlarmReceiveResult receiveResult = new AlarmReceiveResult("10", "alarmItem validate not passed, please check final score >= 5");
                return this.generateXmlModelAndView(receiveResult);
            }
        }
        catch (Exception e) {
            logger.error("validate alarmItem error with message: " + e.getMessage(), (Throwable)e);
            AlarmReceiveResult receiveResult = new AlarmReceiveResult("13", "validate alarmItem error with message: " + e.getMessage());
            return this.generateXmlModelAndView(receiveResult);
        }
        this.alarmItemDAO.saveAlarmItem((AlarmItem)request);
        return this.generateXmlModelAndView(AlarmReceiveResultBuilder.success());
    }

    @RequestMapping(value={"/alarmItem/list"}, produces={"application/json"})
    public ModelAndView listAlarmItem(AlarmItemRequest request, HttpServletRequest httpServletRequest) {
        if (request == null) {
            request = new AlarmItemRequest();
        }
        List alarmItemList = this.alarmItemDAO.findAlarmItem((AlarmItem)request);
        try {
            logger.info("listAlarmItem... queryString: {}, response: {}", (Object)httpServletRequest.getQueryString(), (Object)((ObjectMapper)this.mapper.get()).writeValueAsString((Object)alarmItemList));
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return this.generateJsonModelAndView(alarmItemList);
    }

    @RequestMapping(value={"/alarmItem/update"}, produces={"application/xml"})
    public ModelAndView updateAlarmItem(AlarmItemRequest request, HttpServletRequest httpServletRequest) {
        logger.info("addAlarmItem...queryString:{}", (Object)httpServletRequest.getQueryString());
        Long id = request.getId();
        if (id == null) {
            AlarmReceiveResult receiveResult = new AlarmReceiveResult("13", "id could not be null!");
            return this.generateXmlModelAndView(receiveResult);
        }
        this.alarmItemDAO.updateAlarmItem((AlarmItem)request);
        return this.generateXmlModelAndView(AlarmReceiveResultBuilder.success());
    }
}

