/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.engine.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.alarm.Alarm;
import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmItemDAO;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.engine.AlarmEngine;
import com.xunlei.channel.alarmcenter.strategy.core.StrategyProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class ScoreAlarmEngineImpl
implements AlarmEngine {
    private static final Logger logger = LoggerFactory.getLogger(ScoreAlarmEngineImpl.class);
    @Autowired
    private StrategyProcessor strategyProcessor;
    @Autowired
    private AlarmItemDAO alarmItemDAO;
    @Autowired
    private Alarm alarm;

    @Override
    public AlarmItem getAlarmItem(AlarmData data) {
        AlarmItem alarmItemQuery = new AlarmItem();
        alarmItemQuery.setAlarmId(data.getAlarmId());
        alarmItemQuery.setInUse(Boolean.valueOf(true));
        List alarmItemList = this.alarmItemDAO.findAlarmItem(alarmItemQuery);
        if (alarmItemList == null || alarmItemList.size() == 0) {
            logger.error("alarmId: {} couldn't found corresponding alarmItem", (Object)data.getAlarmId());
        }
        Assert.notNull((Object)alarmItemList, (String)("alarmId: {" + data.getAlarmId() + "} couldn't found corresponding alarmItem"));
        if (alarmItemList.size() > 1) {
            try {
                if (logger.isWarnEnabled()) {
                    logger.warn("alarmId: {} found two corresponding alarmItems: {}", (Object)data.getAlarmId(), (Object)new ObjectMapper().writeValueAsString((Object)alarmItemList));
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        AlarmItem alarmItem = (AlarmItem)alarmItemList.get(0);
        return alarmItem;
    }

    @Override
    public boolean alarm(AlarmData data) {
        Assert.notNull((Object)data, (String)"AlarmData must not be null\uff01");
        AlarmItem alarmItem = this.getAlarmItem(data);
        boolean isAlarm = false;
        try {
            isAlarm = this.strategyProcessor.isAlarm(alarmItem);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("alarmItem: {}, return isAlarm: {}", (Object)new ObjectMapper().writeValueAsString((Object)alarmItem), (Object)isAlarm);
            }
            catch (JsonProcessingException e) {
                // empty catch block
            }
        }
        if (isAlarm) {
            try {
                boolean alarmRight = this.alarm.alarm(data);
                if (alarmRight) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("alarm success with data: {}", (Object)new ObjectMapper().writeValueAsString((Object)data));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("alarm fail with data: {}", (Object)new ObjectMapper().writeValueAsString((Object)data));
                }
                return alarmRight;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean validate(AlarmItem alarmItem) throws Exception {
        if (alarmItem == null || StringUtils.isEmpty((Object)alarmItem.getStrategy())) {
            return true;
        }
        return this.strategyProcessor.validate(alarmItem);
    }
}

