/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.strategy.impl.time.intercept;

import com.xunlei.channel.alarmcenter.common.cache.MemoryCache;
import com.xunlei.channel.alarmcenter.strategy.impl.time.pattern.TimePattern;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TimePatternParseInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TimePatternParseInterceptor.class);
    public static final String CACHE_GROUP_ID = TimePatternParseInterceptor.class.getName();

    public TimePattern getTimePattern(ProceedingJoinPoint call, String ignore) {
        MemoryCache cacheInstance = MemoryCache.getCacheInstance((String)CACHE_GROUP_ID, TimePattern.class);
        TimePattern timePattern = (TimePattern)cacheInstance.get(ignore);
        logger.debug("ignore: {}, get cached TimePattern: {}", (Object)ignore, (Object)timePattern);
        if (timePattern == null) {
            TimePattern proceed = null;
            try {
                proceed = (TimePattern)call.proceed();
                logger.debug("no TimePattern cached, get: {} from origin with ignore: {} ", (Object)proceed, (Object)ignore);
            }
            catch (Throwable throwable) {
                logger.error("", throwable);
            }
            if (proceed != null) {
                cacheInstance.set(ignore, (Object)proceed);
                return proceed;
            }
        }
        return timePattern;
    }
}

