/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.strategy.impl.time;

import com.xunlei.channel.alarmcenter.strategy.AbstractStrategy;
import com.xunlei.channel.alarmcenter.strategy.impl.time.TimePatternParse;
import com.xunlei.channel.alarmcenter.strategy.impl.time.pattern.TimePattern;
import com.xunlei.channel.alarmcenter.strategy.vo.TimeStrategyVo;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class TimeStrategy<T>
extends AbstractStrategy<TimeStrategyVo> {
    private static final Logger logger = LoggerFactory.getLogger(TimeStrategy.class);
    @Autowired
    private TimePatternParse timePatternParse;

    @Override
    public Integer calculateScore(TimeStrategyVo timeStrategyVo) throws Exception {
        List<String> ignores = timeStrategyVo.getIgnores();
        for (String ignore : ignores) {
            TimePattern timePattern = this.timePatternParse.getTimePattern(ignore);
            Assert.notNull((Object)timePattern, (String)MessageFormat.format("could not found TimePattern for pattern value:{0}  !", ignore));
            boolean inTime = timePattern.isInTime(ignore, this.getNow());
            if (logger.isDebugEnabled()) {
                logger.debug("timeStrategyVo: {}, gets timePattern: {}, ignore pattern value: {}, is ignore: {}", new Object[]{timeStrategyVo, timePattern, ignore, inTime});
            }
            if (!inTime) continue;
            return timeStrategyVo.getPoint();
        }
        return 0;
    }

    @Override
    public Integer getMaxScore(TimeStrategyVo timeStrategyVo) throws Exception {
        if (timeStrategyVo.getPoint() < 0) {
            return 0;
        }
        return timeStrategyVo.getPoint();
    }

    @Override
    public Integer getMinScore(TimeStrategyVo timeStrategyVo) throws Exception {
        if (timeStrategyVo.getPoint() > 0) {
            return 0;
        }
        return timeStrategyVo.getPoint();
    }

    protected Date getNow() {
        return new Date();
    }
}

