/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.strategy;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.strategy.Strategy;
import com.xunlei.channel.alarmcenter.strategy.vo.StrategyVo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractStrategy<T extends StrategyVo>
implements Strategy<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStrategy.class);
    private static final ThreadLocal<ObjectMapper> MAPPER_THREAD_LOCAL = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private Class<? extends StrategyVo> entityClass;
    private String jsonRootName;

    public AbstractStrategy() {
        try {
            Type genType = this.getClass().getGenericSuperclass();
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            this.entityClass = (Class)params[0];
            if (this.entityClass.isAnnotationPresent(JsonRootName.class)) {
                this.jsonRootName = this.entityClass.getAnnotation(JsonRootName.class).value();
                logger.info("StrategyVo class: {}, auto generate by it's annotation name, result: {}", this.entityClass, (Object)this.jsonRootName);
            } else {
                this.jsonRootName = this.entityClass.getSimpleName().substring(0, 1) + this.entityClass.getSimpleName().substring(1);
                logger.info("StrategyVo class: {}, auto generate by it's class name, result: {}", this.entityClass, (Object)this.jsonRootName);
            }
        }
        catch (Exception e) {
            logger.error("error when parse generic type", (Throwable)e);
        }
    }

    public abstract Integer calculateScore(T var1) throws Exception;

    public abstract Integer getMaxScore(T var1) throws Exception;

    public abstract Integer getMinScore(T var1) throws Exception;

    @Override
    public Integer calculateScore(AlarmItem item) throws Exception {
        Assert.notNull((Object)item, (String)"item couldn't be null!");
        String strategy = item.getStrategy();
        if (!StringUtils.hasText((String)strategy)) {
            logger.error("alarmId: {} has no strategy!", (Object)item.getAlarmId());
            return null;
        }
        T strategyVo = this.parseStrategyVo(item);
        if (strategyVo == null) {
            return 0;
        }
        Integer score = this.calculateScore(strategyVo);
        if (logger.isDebugEnabled()) {
            logger.debug("item: {}, get score: {}", (Object)MAPPER_THREAD_LOCAL.get().writeValueAsString((Object)item), (Object)score);
        }
        return score;
    }

    @Override
    public Integer getMaxScore(AlarmItem item) throws Exception {
        T strategyVo = this.parseStrategyVo(item);
        return strategyVo == null ? 0 : this.getMaxScore(strategyVo);
    }

    @Override
    public Integer getMinScore(AlarmItem item) throws Exception {
        T strategyVo = this.parseStrategyVo(item);
        return strategyVo == null ? 0 : this.getMinScore(strategyVo);
    }

    protected T parseStrategyVo(AlarmItem item) throws Exception {
        String strategy = item.getStrategy();
        try {
            JsonNode mapJsonNode = MAPPER_THREAD_LOCAL.get().readTree(strategy);
            JsonNode rootNode = mapJsonNode.get(this.jsonRootName);
            String s = rootNode.toString();
            StrategyVo strategyVo = (StrategyVo)MAPPER_THREAD_LOCAL.get().readValue(s, this.entityClass);
            if (logger.isDebugEnabled()) {
                logger.debug("strategy: {} parse to pojo: {}", (Object)strategy, (Object)MAPPER_THREAD_LOCAL.get().writeValueAsString((Object)strategyVo));
            }
            return (T)strategyVo;
        }
        catch (Exception e) {
            logger.error("parse StrategyVo error, strategy: {}, StrategyVo jsonRootName: {}", (Object)strategy, (Object)this.jsonRootName);
            return null;
        }
    }
}

