/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.strategy.impl.time.pattern;

import com.xunlei.channel.alarmcenter.strategy.impl.time.PatternWord;
import com.xunlei.channel.alarmcenter.strategy.impl.time.pattern.TimePattern;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HourMinuteSectionTimePattern
implements TimePattern {
    private static final Logger logger = LoggerFactory.getLogger(HourMinuteSectionTimePattern.class);

    @Override
    public String supportPattern() {
        return "" + (Object)((Object)PatternWord.HOUR) + (Object)((Object)PatternWord.HOUR) + ":" + (Object)((Object)PatternWord.MINUTE) + (Object)((Object)PatternWord.MINUTE) + "-" + (Object)((Object)PatternWord.HOUR) + (Object)((Object)PatternWord.HOUR) + ":" + (Object)((Object)PatternWord.MINUTE) + (Object)((Object)PatternWord.MINUTE);
    }

    @Override
    public boolean isInTime(String value, Date now) {
        try {
            int hourFrom = Integer.parseInt(value.substring(0, 2));
            int minuteFrom = Integer.parseInt(value.substring(3, 5));
            int hourTo = Integer.parseInt(value.substring(6, 8));
            int minuteTo = Integer.parseInt(value.substring(9, 11));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            boolean hit = this.calculate(hourFrom, minuteFrom, hourTo, minuteTo, hour, minute);
            logger.debug("hourFrom: {}, minuteFrom: {}, hourTo: {}, minuteTo: {}, hour: {}, minute: {}, inTime: {}", new Object[]{hourFrom, minuteFrom, hourTo, minuteTo, hour, minute, hit});
            return hit;
        }
        catch (Exception e) {
            logger.error("parse pattern error, catch exception message: {}! pattern format value: {} with pattern: {}", new Object[]{e.getMessage(), value, this.supportPattern()});
            return false;
        }
    }

    protected boolean calculate(int hourFrom, int minuteFrom, int hourTo, int minuteTo, int hour, int minute) {
        if (hourFrom < hourTo) {
            return (hour > hourFrom || hour == hourFrom && minute >= minuteFrom) && (hour < hourTo || hour == hourTo && minute < minuteTo);
        }
        if (hourFrom > hourTo) {
            return hour > hourFrom || hour == hourFrom && minute >= minuteFrom || hour < hourTo || hour == hourTo && minute < minuteTo;
        }
        if (minuteFrom > minuteTo) {
            return hour == hourFrom && minute >= minuteFrom || hour > hourFrom || hour == hourTo && minute < minuteTo || hour < hourTo;
        }
        if (minuteFrom < minuteTo) {
            return minute >= minuteFrom && minute < minuteTo;
        }
        return minute == minuteFrom;
    }
}

