/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.strategy.impl.time.pattern;

import com.xunlei.channel.alarmcenter.strategy.impl.time.PatternWord;
import com.xunlei.channel.alarmcenter.strategy.impl.time.pattern.TimePattern;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DayOfWeekSectionTimePattern
implements TimePattern {
    private static final Logger logger = LoggerFactory.getLogger(DayOfWeekSectionTimePattern.class);

    @Override
    public String supportPattern() {
        return "" + (Object)((Object)PatternWord.WEEK) + "-" + (Object)((Object)PatternWord.WEEK);
    }

    private int getChinaDayOfWeek(int i) {
        switch (i) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 1: {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public boolean isInTime(String value, Date now) {
        try {
            int dayOfWeekFrom = Integer.parseInt(value.substring(0, 1));
            int dayOfWeekTo = Integer.parseInt(value.substring(2, 3));
            if (dayOfWeekFrom == 1 && dayOfWeekTo == 7) {
                logger.error("invalid config, dayOfWeekFrom is 1 and dayOfWeekTo is 7! please check!");
                return true;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            int dayOfWeek = calendar.get(7);
            int chinaDayOfWeek = this.getChinaDayOfWeek(dayOfWeek);
            if (logger.isDebugEnabled()) {
                logger.debug("date: {}, get dayOfWeek: {}, parse to chinaDayOfWeek", new Object[]{now, dayOfWeek, chinaDayOfWeek});
            }
            return chinaDayOfWeek >= dayOfWeekFrom && chinaDayOfWeek <= dayOfWeekTo;
        }
        catch (Exception e) {
            logger.error("parse pattern error, catch exception message: {}! pattern format value: {} with pattern: {}", new Object[]{e.getMessage(), value, this.supportPattern()});
            return false;
        }
    }
}

