/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.strategy.core;

import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.strategy.Strategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class StrategyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StrategyProcessor.class);
    public static final int MIN_ALARM_SCORE = 5;
    @Autowired
    private List<Strategy> strategies;

    public Integer calculateScore(AlarmItem item) throws Exception {
        Assert.notNull(this.strategies, (String)"strategy not implements!");
        Integer scoreSum = 0;
        for (Strategy strategy : this.strategies) {
            Integer score = strategy.calculateScore(item);
            if (logger.isDebugEnabled()) {
                logger.debug("strategy: {}, return score: {}", strategy.getClass(), (Object)score);
            }
            Assert.notNull((Object)score, (String)"calculate score return null!");
            scoreSum = scoreSum + score;
        }
        return scoreSum;
    }

    public boolean validate(AlarmItem item) {
        int max = 0;
        try {
            for (Strategy strategy : this.strategies) {
                max += strategy.getMaxScore(item).intValue();
            }
        }
        catch (Exception e) {
            logger.error("test catch exception! message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return max >= 5;
    }

    public boolean isAlarm(AlarmItem item) throws Exception {
        Integer score = this.calculateScore(item);
        return score >= 5;
    }
}

