/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.common.cache;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache<T> {
    private static final Logger logger = LoggerFactory.getLogger(MemoryCache.class);
    private String groupId;
    private static Map<String, MemoryCache> allCache = new HashMap<String, MemoryCache>();
    private Map<String, T> cacheMap = new HashMap<String, T>();

    private MemoryCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> MemoryCache<E> getCacheInstance(String groupId, Class<E> valueType) {
        MemoryCache memoryCache = allCache.get(groupId);
        if (memoryCache == null) {
            String string = groupId.intern();
            synchronized (string) {
                memoryCache = new MemoryCache();
                memoryCache.groupId = groupId;
                allCache.put(groupId, memoryCache);
            }
        }
        return memoryCache;
    }

    public static MemoryCache<Object> getCacheInstance(String groupId) {
        return MemoryCache.getCacheInstance(groupId, Object.class);
    }

    public void set(String key, T value) {
        this.cacheMap.put(key, value);
    }

    public T get(String key) {
        return this.cacheMap.get(key);
    }

    public static void set(String groupId, String key, Object object) {
        MemoryCache<Object> cacheInstance = MemoryCache.getCacheInstance(groupId);
        cacheInstance.set(key, object);
    }

    public static Object get(String groupId, String key) {
        MemoryCache<Object> cacheInstance = MemoryCache.getCacheInstance(groupId);
        return cacheInstance.get(key);
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Map<String, T> getCacheMap() {
        return this.cacheMap;
    }
}

