/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarm.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.xiongyingqi.http.HttpAccess;
import com.xiongyingqi.http.HttpBuilder;
import com.xiongyingqi.util.Assert;
import com.xiongyingqi.util.CollectionUtils;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.dbservice.pojo.Contact;
import com.xunlei.channel.alarmcenter.receive.pojo.AlarmReceiveResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AlarmApi {
    private static final Logger logger = LoggerFactory.getLogger(AlarmApi.class);
    private String alarmBaseUrl;
    private final String alarmApiAddContact;
    private final String alarmApiUpdateContact;
    private final String alarmApiListContact;
    private final String alarmApiAddAlarmItem;
    private final String alarmApiUpdateAlarmItem;
    private final String alarmApiListAlarmItem;
    private final String alarmApiAddAlarm;
    private final String alarmApiListAlarm;
    private final ThreadLocal<CloseableHttpClient> client = new ThreadLocal<CloseableHttpClient>(){

        @Override
        protected CloseableHttpClient initialValue() {
            return HttpAccess.getClient();
        }
    };
    private final ThreadLocal<ObjectMapper> objectMapper = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private final ThreadLocal<XmlMapper> xmlMapper = new ThreadLocal<XmlMapper>(){

        @Override
        protected XmlMapper initialValue() {
            return new XmlMapper();
        }
    };
    public static final String ALARM_RECEIVE_RESULT_SUCCESS_CODE = "00";

    public AlarmApi(String alarmBaseUrl) throws Exception {
        Assert.hasText((String)alarmBaseUrl, (String)"must preset alarmBaseUrl!");
        this.alarmBaseUrl = alarmBaseUrl.endsWith("/") ? alarmBaseUrl.substring(0, alarmBaseUrl.length() - 1) : alarmBaseUrl;
        this.alarmApiAddContact = this.alarmBaseUrl + "/contacts/request";
        this.alarmApiUpdateContact = this.alarmBaseUrl + "/contacts/update";
        this.alarmApiListContact = this.alarmBaseUrl + "/contacts/list";
        this.alarmApiAddAlarmItem = this.alarmBaseUrl + "/alarmItem/request";
        this.alarmApiUpdateAlarmItem = this.alarmBaseUrl + "/alarmItem/update";
        this.alarmApiListAlarmItem = this.alarmBaseUrl + "/alarmItem/list";
        this.alarmApiAddAlarm = this.alarmBaseUrl + "/alarm/request";
        this.alarmApiListAlarm = this.alarmBaseUrl + "/alarm/list";
    }

    public AlarmReceiveResult addContact(Contact contact) throws Exception {
        Assert.notNull((Object)contact, (String)"contact could'nt be null!");
        if (contact.isInUse() == null) {
            contact.setInUse(Boolean.valueOf(true));
        }
        HttpBuilder builder = HttpBuilder.newBuilder().url(this.alarmApiAddContact);
        builder.param("name", contact.getName());
        builder.param("email", contact.getEmail());
        builder.param("mobile", contact.getMobile());
        builder.param("extraJson", contact.getExtraJson());
        builder.param("inUse", contact.isInUse() + "");
        String s = HttpAccess.execute((CloseableHttpClient)this.client.get(), (HttpRequestBase)builder.build());
        AlarmReceiveResult receiveResult = this.parseResult(s);
        return receiveResult;
    }

    public AlarmReceiveResult updateContact(Contact contact) throws Exception {
        Assert.notNull((Object)contact, (String)"contact could'nt be null!");
        Assert.notNull((Object)contact.getId(), (String)"contact id must preset!");
        HttpBuilder builder = HttpBuilder.newBuilder().url(this.alarmApiUpdateContact);
        builder.param("id", contact.getId() == null ? "" : contact.getId() + "");
        builder.param("name", contact.getName());
        builder.param("email", contact.getEmail());
        builder.param("mobile", contact.getMobile());
        builder.param("extraJson", contact.getExtraJson());
        builder.param("inUse", contact.isInUse() + "");
        String s = HttpAccess.execute((CloseableHttpClient)this.client.get(), (HttpRequestBase)builder.build());
        AlarmReceiveResult receiveResult = this.parseResult(s);
        return receiveResult;
    }

    public Collection<Contact> listContact(Contact contact) throws Exception {
        Assert.notNull((Object)contact, (String)"contact could'nt be null!");
        HttpBuilder builder = HttpBuilder.newBuilder().url(this.alarmApiListContact);
        builder.param("id", contact.getId() == null ? "" : contact.getId() + "");
        builder.param("name", contact.getName());
        builder.param("email", contact.getEmail());
        builder.param("mobile", contact.getMobile());
        builder.param("extraJson", contact.getExtraJson());
        String s = HttpAccess.execute((CloseableHttpClient)this.client.get(), (HttpRequestBase)builder.build());
        Collection<Contact> contacts = this.parseResultToCollectionWithPojoClass(s, Contact.class);
        return contacts;
    }

    public Collection<AlarmItem> findAlarmItem(String alarmId) {
        try {
            String s;
            HttpBuilder builder = HttpBuilder.newBuilder().url(this.alarmApiListAlarmItem);
            if (StringUtils.hasText((String)alarmId)) {
                builder.param("alarmId", alarmId);
            }
            if (StringUtils.hasText((String)(s = HttpAccess.execute((CloseableHttpClient)this.client.get(), (HttpRequestBase)builder.build())))) {
                Collection<AlarmItem> alarmItemCollection = this.parseResultToCollectionWithPojoClass(s, AlarmItem.class);
                if (logger.isDebugEnabled()) {
                    logger.debug("findAlarmItem... alarmId: {}, return: {}, parse result: {}", new Object[]{alarmId, s, alarmItemCollection});
                }
                return alarmItemCollection;
            }
            logger.error("findAlarmItem error... alarmId: {}, return null", (Object)alarmId);
        }
        catch (Exception e) {
            logger.error("init AlarmService error! ", (Throwable)e);
        }
        return null;
    }

    public Collection<AlarmItem> listAlarmItem() {
        return this.findAlarmItem(null);
    }

    public AlarmReceiveResult updateAlarmItem(Long id, AlarmItem alarmItem) {
        try {
            HttpBuilder builder = HttpBuilder.newBuilder().url(this.alarmApiUpdateAlarmItem);
            if (id != null && id >= 0L) {
                builder.param("id", id + "");
                builder.param("alarmId", alarmItem.getAlarmId());
                builder.param("name", alarmItem.getName());
                builder.param("inUse", alarmItem.getInUse() + "");
                builder.param("owner", alarmItem.getOwner());
                builder.param("description", alarmItem.getDescription());
                builder.param("strategy", alarmItem.getStrategy());
            }
            String s = HttpAccess.execute((CloseableHttpClient)this.client.get(), (HttpRequestBase)builder.build());
            return this.parseResult(s);
        }
        catch (Exception e) {
            logger.error("init AlarmService error! ", (Throwable)e);
            return null;
        }
    }

    public AlarmReceiveResult addAlarmItem(AlarmItem alarmItem) {
        try {
            HttpBuilder builder = HttpBuilder.newBuilder().url(this.alarmApiAddAlarmItem);
            builder.param("alarmId", alarmItem.getAlarmId());
            builder.param("name", alarmItem.getName());
            builder.param("inUse", alarmItem.getInUse() + "");
            builder.param("owner", alarmItem.getOwner());
            builder.param("description", alarmItem.getDescription());
            builder.param("strategy", alarmItem.getStrategy());
            String s = HttpAccess.execute((CloseableHttpClient)this.client.get(), (HttpRequestBase)builder.build());
            return this.parseResult(s);
        }
        catch (Exception e) {
            logger.error("init AlarmService error! ", (Throwable)e);
            return null;
        }
    }

    public AlarmReceiveResult setAlarmItem(AlarmItem alarmItem) throws Exception {
        Assert.notNull((Object)alarmItem, (String)"alarmItem couldn't be null!");
        Assert.hasText((String)alarmItem.getAlarmId(), (String)"alarmId must has text!");
        Collection<AlarmItem> alarmItemCollection = this.findAlarmItem(alarmItem.getAlarmId());
        if (!CollectionUtils.isEmpty(alarmItemCollection)) {
            for (AlarmItem item : alarmItemCollection) {
                item.setInUse(Boolean.valueOf(false));
                try {
                    this.updateAlarmItem(item.getId(), item);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        return this.addAlarmItem(alarmItem);
    }

    public AlarmReceiveResult addAlarmData(AlarmData alarmData) throws Exception {
        Assert.notNull((Object)alarmData, (String)"alarmData couldn't be null!");
        Assert.hasText((String)alarmData.getAlarmId(), (String)"alarmId must has text!");
        Assert.hasText((String)alarmData.getContent(), (String)"content must has text!");
        try {
            HttpBuilder builder = HttpBuilder.newBuilder().url(this.alarmApiAddAlarm);
            builder.param("alarmId", alarmData.getAlarmId());
            builder.param("content", alarmData.getContent());
            builder.param("groupId", alarmData.getGroupId());
            String s = HttpAccess.execute((CloseableHttpClient)this.client.get(), (HttpRequestBase)builder.build());
            return this.parseResult(s);
        }
        catch (Exception e) {
            logger.error("init AlarmService error! ", (Throwable)e);
            return null;
        }
    }

    protected AlarmReceiveResult parseResult(String s) throws Exception {
        if (StringUtils.hasText((String)s)) {
            AlarmReceiveResult result = (AlarmReceiveResult)this.xmlMapper.get().readValue(s, AlarmReceiveResult.class);
            if (logger.isDebugEnabled()) {
                logger.debug("Parse Result... s: {}, result: {}", (Object)s, (Object)this.objectMapper.get().writeValueAsString((Object)result));
            }
            return result;
        }
        return null;
    }

    public boolean isSuccess(String s) throws Exception {
        if (StringUtils.hasText((String)s)) {
            AlarmReceiveResult result = this.parseResult(s);
            return this.isSuccess(result);
        }
        return false;
    }

    public boolean isSuccess(AlarmReceiveResult result) throws Exception {
        if (result == null) {
            return false;
        }
        return result.getCode() != null && result.getCode().equals(ALARM_RECEIVE_RESULT_SUCCESS_CODE);
    }

    public <T> Collection<T> parseResultToCollectionWithPojoClass(String s, Class<T> clazz) throws IOException {
        CollectionType javaType = CollectionType.construct(ArrayList.class, (JavaType)SimpleType.construct(clazz));
        Collection collection = (Collection)this.objectMapper.get().readValue(s, (JavaType)javaType);
        return collection;
    }

    public static void main(String[] args) {
        String url = "http://baidu.com/";
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        System.out.println(url);
        int a = 1;
        int b = 2;
        a += b;
        b = a - b;
        System.out.println(a -= b);
        System.out.println(b);
        a |= b;
        b = a ^ b;
        System.out.println(a ^= b);
        System.out.println(b);
    }
}

