/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.sender.sms.service.impl;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.xunlei.channel.alarmcenter.alarm.sender.sms.SmsConfiguration;
import com.xunlei.channel.alarmcenter.alarm.sender.sms.SmsSignatureHelper;
import com.xunlei.channel.alarmcenter.alarm.sender.sms.service.SmsService;
import com.xunlei.channel.alarmcenter.alarm.sender.sms.vo.SmsResult;
import com.xunlei.channel.alarmcenter.common.io.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsServiceImpl
implements SmsService {
    private static final Logger logger = LoggerFactory.getLogger(SmsServiceImpl.class);
    public static final String VERSION = "v1.0";
    public static final String PAGE_CHARSET = "GBK";
    public static final String SEND_SUCCESS = "00";
    private final ThreadLocal<XmlMapper> mapper = new ThreadLocal<XmlMapper>(){

        @Override
        protected XmlMapper initialValue() {
            return new XmlMapper();
        }
    };
    @Autowired
    private SmsConfiguration configuration;

    @Override
    public boolean sendMessage(String mobile, String content) {
        String bizNo = this.configuration.getBizNo();
        String bizKey = this.configuration.getBizKey();
        String smsUrl = this.configuration.getUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", VERSION);
        params.put("pageCharset", PAGE_CHARSET);
        params.put("bizNo", bizNo);
        params.put("mobile", mobile);
        params.put("content", content);
        String signMessage = this.getSignMessage(params, bizKey);
        params.put("signMsg", signMessage);
        try {
            SmsResult result = this.request(smsUrl, params);
            String sendResult = result.getSendResult();
            if (sendResult != null && sendResult.trim().equals(SEND_SUCCESS)) {
                return true;
            }
            logger.error("send sms error! sendResult: {}, errorCode: {}", (Object)sendResult, (Object)result.getErrorCode());
            return false;
        }
        catch (Exception e) {
            logger.error("send sms error: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public SmsResult request(String url, Map<String, String> params) throws URISyntaxException, IOException {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(url);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            requestBuilder.addParameter(key, value);
        }
        HttpUriRequest request = requestBuilder.build();
        CloseableHttpResponse response = closeableHttpClient.execute(request);
        HttpEntity entity = response.getEntity();
        InputStream inputStream = entity.getContent();
        String content = StreamHelper.inputStreamToString((InputStream)inputStream);
        if (logger.isDebugEnabled()) {
            logger.debug("request sms api, url: {}, parameters map: {}, response: {}", new Object[]{url, params, content});
        }
        SmsResult smsResult = (SmsResult)this.mapper.get().readValue(content, SmsResult.class);
        return smsResult;
    }

    public String getSignMessage(Map<String, String> params, String bizKey) {
        return SmsSignatureHelper.sign(params, bizKey);
    }
}

