/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.sender.sms;

import com.xunlei.channel.alarmcenter.common.util.Md5Encrypt;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SmsSignatureHelper {
    private static final Logger logger = LoggerFactory.getLogger(SmsSignatureHelper.class);

    public static String sign(Map<String, String> param, String privateKey) {
        String content = SmsSignatureHelper.getSignatureContent(param);
        logger.debug("params: {}, singed message: {}", param, (Object)content);
        return SmsSignatureHelper.sign(content, privateKey);
    }

    public static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5((String)(content + privateKey));
    }

    public static String getSignatureContent(Map<String, String> param) {
        return SmsSignatureHelper.getSignatureContent(param, null);
    }

    public static String getSignatureContent(Map<String, String> param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || StringUtils.isEmpty((Object)(value = param.get(key)))) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = prop.getProperty(key);
            if (!StringUtils.isEmpty((Object)encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append(i == 0 ? "" : "&");
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }
}

