/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.sender.sms;

import com.xunlei.channel.alarmcenter.common.util.PropertiesUtil;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SmsConfiguration
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SmsConfiguration.class);
    public static final String PROPERTIES_FILE_NAME = "sms.properties";
    public static final String PROPERTIES_SMS_URL = "sms.url";
    public static final String PROPERTIES_BIZ_NO = "sms.bizNo";
    public static final String PROPERTIES_BIZ_KEY = "sms.bizKey";
    private String url;
    private String bizNo;
    private String bizKey;

    private void loadProperties() {
        try {
            Properties properties = PropertiesUtil.getProperties((InputStream)SmsConfiguration.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME));
            this.url = properties.getProperty(PROPERTIES_SMS_URL);
            this.bizNo = properties.getProperty(PROPERTIES_BIZ_NO);
            this.bizKey = properties.getProperty(PROPERTIES_BIZ_KEY);
        }
        catch (Exception e) {
            logger.error("load sms config error: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBizNo() {
        return this.bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public String getBizKey() {
        return this.bizKey;
    }

    public void setBizKey(String bizKey) {
        this.bizKey = bizKey;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadProperties();
    }
}

