/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.sender.email.factory;

import com.xunlei.channel.alarmcenter.alarm.sender.email.vo.EmailAccount;
import java.util.Properties;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class JavaMailSenderFactory
extends JavaMailSenderImpl {
    private String systemEmail;
    private String defaultCc;
    private String defaultBcc;
    private EmailAccount emailAccount;

    private JavaMailSenderFactory(EmailAccount emailAccount) {
        this.emailAccount = emailAccount;
        this.systemEmail = emailAccount.getSystemEmail();
        this.defaultCc = emailAccount.getCc();
        this.defaultBcc = emailAccount.getBcc();
        super.setProtocol(emailAccount.getProtocol());
        super.setHost(emailAccount.getHost());
        super.setPort(emailAccount.getPort());
        super.setUsername(emailAccount.getUsername());
        super.setPassword(emailAccount.getPassword());
        Properties properties = new Properties();
        properties.setProperty("mail." + emailAccount.getProtocol() + ".auth", emailAccount.isAuth() + "");
        super.setJavaMailProperties(properties);
    }

    public static JavaMailSenderFactory buildNewJavaMailSender(EmailAccount emailAccount) {
        return new JavaMailSenderFactory(emailAccount);
    }

    public String getSystemEmail() {
        return this.systemEmail;
    }

    public void setSystemEmail(String systemEmail) {
        this.systemEmail = systemEmail;
    }

    public String getDefaultCc() {
        return this.defaultCc;
    }

    public void setDefaultCc(String defaultCc) {
        this.defaultCc = defaultCc;
    }

    public String getDefaultBcc() {
        return this.defaultBcc;
    }

    public void setDefaultBcc(String defaultBcc) {
        this.defaultBcc = defaultBcc;
    }

    public EmailAccount getEmailAccount() {
        return this.emailAccount;
    }

    public void setEmailAccount(EmailAccount emailAccount) {
        this.emailAccount = emailAccount;
    }
}

