/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.sender.sms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.alarm.sender.MessageSender;
import com.xunlei.channel.alarmcenter.alarm.sender.sms.service.SmsService;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.dbservice.pojo.Contact;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MobileMessageSender
implements MessageSender {
    private static final Logger logger = LoggerFactory.getLogger(MobileMessageSender.class);
    @Autowired
    private SmsService smsService;

    @Override
    public boolean sendMessage(Collection<Contact> contacts, AlarmItem alarmItem, AlarmData alarmData) throws Exception {
        boolean success = true;
        StringBuilder builder = new StringBuilder();
        if (alarmItem != null && StringUtils.hasText((String)alarmItem.getName())) {
            builder.append(alarmItem.getName());
            if (StringUtils.hasText((String)alarmItem.getDescription())) {
                builder.append(" [");
                builder.append(alarmItem.getDescription());
                builder.append("]");
            }
            builder.append(" ");
        }
        String content = builder.append(alarmData.getContent()).toString();
        if (logger.isInfoEnabled()) {
            ObjectMapper mapper = new ObjectMapper();
            logger.info("alarmItem: " + mapper.writeValueAsString((Object)alarmItem) + ", alarmData: " + mapper.writeValueAsString((Object)alarmData) + ", content: " + content);
        }
        for (Contact contact : contacts) {
            String mobile = contact.getMobile();
            if (StringUtils.isEmpty((Object)mobile)) {
                logger.error("contactId: {}, contactName: {} has no mobile! continue with next contacts!", (Object)contact.getId(), (Object)contact.getName());
                continue;
            }
            boolean sendSuccess = this.smsService.sendMessage(mobile, content);
            boolean bl = success = success && sendSuccess;
            if (sendSuccess) continue;
            ObjectMapper mapper = new ObjectMapper();
            logger.error("send sms error! contact: {}, alarmData: {}", (Object)mapper.writeValueAsString((Object)contact), (Object)mapper.writeValueAsString((Object)alarmData));
        }
        return success;
    }
}

