/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.sender.email.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.alarm.sender.email.factory.JavaMailSenderFactory;
import com.xunlei.channel.alarmcenter.alarm.sender.email.service.EmailService;
import com.xunlei.channel.alarmcenter.alarm.sender.email.vo.AttachmentVo;
import com.xunlei.channel.alarmcenter.alarm.sender.email.vo.EmailAccount;
import com.xunlei.channel.alarmcenter.alarm.sender.email.vo.EmailVo;
import com.xunlei.channel.alarmcenter.alarm.sender.email.vo.InlineImageVo;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class EmailServiceImpl
implements EmailService {
    private static final Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);
    private JavaMailSenderFactory javaMailSenderFactory;
    private EmailAccount emailAccount;
    public static final Pattern PATTERN_FIND_TAG_AND_INDEX = Pattern.compile("<\\w+\\s+\\w+\\s*=\\s*(\\'\\s*\\$\\s*\\{\\s*\\d+\\s*\\}\\s*\\'\\s*|\\\"\\s*\\$\\s*\\{\\s*\\w+\\s*\\}\\s*\\\"\\s*){1}?\\s*/{0,1}>");
    public static final Pattern PATTERN_DOLLAR_VARIABLE_INDEX = Pattern.compile("\\s*\\$\\{\\s*\\d+\\s*\\}\\s*");
    public static final Pattern PATTERN_FIND_TAG = Pattern.compile("<\\w+\\s+src\\s*=\\s*(\\'\\s*\\$\\{\\s*\\w+\\s*\\}\\s*\\'\\s*|\\\"\\s*\\$*\\{\\s*\\w+\\s*\\}\\s*\\\"\\s*){1}?\\s*/{0,1}>");
    public static final Pattern PATTERN_DOLLAR_VARIABLE_SELF_DEFINE = Pattern.compile("\\s*\\$\\{\\s*\\w+\\s*\\}\\s*");

    public EmailServiceImpl(EmailAccount emailAccount) {
        this.javaMailSenderFactory = JavaMailSenderFactory.buildNewJavaMailSender(emailAccount);
    }

    public EmailServiceImpl() {
    }

    public EmailAccount getEmailAccount() {
        return this.emailAccount;
    }

    @Override
    public void setEmailAccount(EmailAccount emailAccount) {
        this.emailAccount = emailAccount;
        this.javaMailSenderFactory = JavaMailSenderFactory.buildNewJavaMailSender(emailAccount);
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("setEmailAccount... emailAccount: {}", (Object)new ObjectMapper().writeValueAsString((Object)emailAccount));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendEmail(EmailVo emailVo) throws MessagingException {
        Assert.notNull((Object)emailVo.getTo(), (String)"\u63a5\u6536\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        MimeMessage msg = this.javaMailSenderFactory.createMimeMessage();
        MimeMessageHelper msgHelper = null;
        msgHelper = emailVo.getInlineImageVos() != null && emailVo.getInlineImageVos().size() > 0 || emailVo.getAttachmentVos() != null && emailVo.getAttachmentVos().size() > 0 ? new MimeMessageHelper(msg, true, "utf-8") : new MimeMessageHelper(msg, "utf-8");
        if (emailVo.getFrom() == null || "".equals(emailVo.getFrom().trim())) {
            emailVo.setFrom(this.javaMailSenderFactory.getSystemEmail());
        }
        if ((emailVo.getCc() == null || "".equals(emailVo.getCc().length == 0)) && this.javaMailSenderFactory.getDefaultCc() != null && !this.javaMailSenderFactory.getDefaultCc().equals("")) {
            emailVo.setCc(this.javaMailSenderFactory.getDefaultCc().split(","));
        }
        if ((emailVo.getBcc() == null || "".equals(emailVo.getBcc().length == 0)) && this.javaMailSenderFactory.getDefaultBcc() != null && !this.javaMailSenderFactory.getDefaultBcc().equals("")) {
            emailVo.setBcc(this.javaMailSenderFactory.getDefaultBcc().split(","));
        }
        if (emailVo.getMessageDate() == null) {
            emailVo.setMessageDate(new Date());
        }
        if (emailVo.getCc() != null) {
            msgHelper.setCc(emailVo.getCc());
        }
        if (emailVo.getBcc() != null) {
            msgHelper.setBcc(emailVo.getBcc());
        }
        if (emailVo.getSubject() != null) {
            msgHelper.setSubject(emailVo.getSubject());
        }
        this.handlerAttachments(emailVo, msgHelper);
        String from = null;
        from = emailVo.getFrom() != null && !"".equals(emailVo.getFrom()) ? emailVo.getFrom() : (this.javaMailSenderFactory.getEmailAccount().getFrom() != null && !"".equals(this.javaMailSenderFactory.getEmailAccount().getFrom()) ? this.javaMailSenderFactory.getEmailAccount().getFrom() : this.javaMailSenderFactory.getEmailAccount().getUsername());
        try {
            if (this.javaMailSenderFactory.getEmailAccount().getNickName() != null) {
                msgHelper.setFrom(from, this.javaMailSenderFactory.getEmailAccount().getNickName());
            } else {
                msgHelper.setFrom(from);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            msgHelper.setFrom(from);
        }
        msgHelper.setTo(emailVo.getTo());
        Collection<Inline> inlines = this.handlerInlineImages(emailVo, msgHelper);
        if (emailVo.getHtml() != null) {
            msgHelper.setText(emailVo.getHtml(), emailVo.isHtml());
            if (inlines != null) {
                for (Inline inline : inlines) {
                    msgHelper.addInline(inline.getContentId(), inline.getFile());
                }
            }
        }
        this.javaMailSenderFactory.send(msg);
    }

    private Collection<Inline> handlerInlineImages(EmailVo emailVo, MimeMessageHelper msgHelper) throws MessagingException {
        HashSet<Inline> inlines = null;
        if (emailVo.getInlineImageVos() != null && emailVo.getInlineImageVos().size() > 0) {
            File file;
            InlineImageVo inlineImageVo;
            inlines = new HashSet<Inline>();
            String html = emailVo.getHtml();
            if (html == null || html.trim().equals("")) {
                return inlines;
            }
            Matcher matcherIndexTag = PATTERN_FIND_TAG_AND_INDEX.matcher(html);
            int contentIdIndex = 0;
            while (matcherIndexTag.find()) {
                String htmlTag = matcherIndexTag.group();
                Matcher matcherDollar = PATTERN_DOLLAR_VARIABLE_INDEX.matcher(htmlTag);
                if (!matcherDollar.find()) continue;
                String dollarFind = matcherDollar.group();
                String indexStr = dollarFind.replace("$", "").replace("{", "").replace("}", "").trim();
                int index = Integer.parseInt(indexStr);
                try {
                    inlineImageVo = emailVo.getInlineImageVos().get(index);
                    file = inlineImageVo.getFile();
                    String contentId = "file" + contentIdIndex++;
                    Inline inline = new Inline();
                    inline.setFile(file);
                    inline.setContentId(contentId);
                    inlines.add(inline);
                    htmlTag = matcherDollar.replaceAll("cid:" + contentId);
                    html = matcherIndexTag.replaceFirst(htmlTag);
                    matcherIndexTag = PATTERN_FIND_TAG_AND_INDEX.matcher(html);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            Matcher matcherTag = PATTERN_FIND_TAG.matcher(html);
            while (matcherTag.find()) {
                String htmlTag = matcherTag.group();
                Matcher matcherDollar = PATTERN_DOLLAR_VARIABLE_SELF_DEFINE.matcher(htmlTag);
                if (!matcherDollar.find()) continue;
                String dollarFind = matcherDollar.group();
                String dollarVariable = dollarFind.replace("$", "").replace("{", "").replace("}", "").trim();
                try {
                    inlineImageVo = null;
                    for (InlineImageVo imageVo : emailVo.getInlineImageVos()) {
                        if (imageVo.getContentId() == null || !imageVo.getContentId().equals(dollarVariable)) continue;
                        inlineImageVo = imageVo;
                    }
                    if (inlineImageVo == null) continue;
                    file = inlineImageVo.getFile();
                    Inline inline = new Inline();
                    inline.setFile(file);
                    inline.setContentId(inlineImageVo.getContentId());
                    inlines.add(inline);
                    htmlTag = matcherDollar.replaceAll("cid:" + inlineImageVo.getContentId());
                    html = matcherTag.replaceFirst(htmlTag);
                    matcherTag = PATTERN_FIND_TAG.matcher(html);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            emailVo.setHtml(html);
            System.out.println(inlines.size());
            if (inlines != null && inlines.size() > 0) {
                emailVo.setHtml(true);
            }
        }
        return inlines;
    }

    private void handlerAttachments(EmailVo emailVo, MimeMessageHelper msgHelper) throws MessagingException {
        if (emailVo.getAttachmentVos() != null) {
            for (AttachmentVo attachmentVo : emailVo.getAttachmentVos()) {
                File attachment = attachmentVo.getAttachment();
                if (attachment == null) {
                    InputStream inputStream = attachmentVo.getAttachmentInputStream();
                    if (attachmentVo.getAttachmentName() == null) {
                        attachmentVo.setAttachmentName(new Date().toString());
                    }
                    InputStreamResource inputStreamSource = new InputStreamResource(inputStream);
                    msgHelper.addAttachment(attachmentVo.getAttachmentName(), (InputStreamSource)inputStreamSource);
                    continue;
                }
                if (attachmentVo.getAttachmentName() == null) {
                    attachmentVo.setAttachmentName(attachment.getName());
                }
                try {
                    msgHelper.addAttachment(MimeUtility.encodeWord((String)attachmentVo.getAttachmentName()), attachment);
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    class Inline {
        private String contentId;
        private File file;

        Inline() {
        }

        public String getContentId() {
            return this.contentId;
        }

        public void setContentId(String contentId) {
            this.contentId = contentId;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }
}

