/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.sender.email;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.alarm.sender.MessageSender;
import com.xunlei.channel.alarmcenter.alarm.sender.email.EmailConfiguration;
import com.xunlei.channel.alarmcenter.alarm.sender.email.service.EmailService;
import com.xunlei.channel.alarmcenter.alarm.sender.email.vo.EmailAccount;
import com.xunlei.channel.alarmcenter.alarm.sender.email.vo.EmailVo;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.dbservice.pojo.Contact;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class EmailMessageSender
implements MessageSender,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(EmailMessageSender.class);
    @Autowired
    private EmailConfiguration emailConfiguration;
    @Autowired
    private EmailService emailService;
    private EmailAccount emailAccount;

    public EmailAccount buildEmailAccount() {
        EmailAccount emailAccount = new EmailAccount();
        emailAccount.setProtocol(this.emailConfiguration.getProperty("email.protocol"));
        emailAccount.setHost(this.emailConfiguration.getProperty("email.host"));
        String auth = this.emailConfiguration.getProperty("email.auth");
        if (StringUtils.isEmpty((Object)auth)) {
            emailAccount.setAuth(true);
        } else {
            emailAccount.setAuth(auth.equals("true"));
        }
        String port = this.emailConfiguration.getProperty("email.port");
        if (StringUtils.isEmpty((Object)port)) {
            if (emailAccount.getProtocol().equals("smtps")) {
                emailAccount.setPort(465);
            } else {
                emailAccount.setPort(25);
            }
        } else {
            emailAccount.setPort(Integer.parseInt(port));
        }
        emailAccount.setUsername(this.emailConfiguration.getProperty("email.userName"));
        emailAccount.setPassword(this.emailConfiguration.getProperty("email.password"));
        emailAccount.setSystemEmail(this.emailConfiguration.getProperty("email.systemEmail"));
        emailAccount.setCc(this.emailConfiguration.getProperty("email.cc"));
        emailAccount.setBcc(this.emailConfiguration.getProperty("email.bcc"));
        return emailAccount;
    }

    @Override
    public boolean sendMessage(Collection<Contact> contacts, AlarmItem alarmItem, AlarmData alarmData) throws Exception {
        EmailAccount emailAccount = this.buildEmailAccount();
        if (!this.emailAccount.equals(emailAccount)) {
            this.emailAccount = emailAccount;
            this.emailService.setEmailAccount(this.emailAccount);
        }
        ArrayList<String> mailTo = new ArrayList<String>();
        for (Contact contact : contacts) {
            if (StringUtils.isEmpty((Object)contact.getEmail())) {
                logger.error("contactId: {}, contactName: {} has no email! continue with next contacts!", (Object)contact.getId(), (Object)contact.getName());
                continue;
            }
            mailTo.add(contact.getEmail());
        }
        EmailVo emailVo = new EmailVo();
        if (alarmItem == null || !StringUtils.hasText((String)alarmItem.getName())) {
            emailVo.setSubject("Alarm message from AlarmCenter[No title]");
        } else {
            StringBuilder builder = new StringBuilder(alarmItem.getName());
            if (StringUtils.hasText((String)alarmItem.getDescription())) {
                builder.append(" [");
                builder.append(alarmItem.getDescription());
                builder.append("]");
            }
            emailVo.setSubject(builder.toString());
        }
        if (logger.isInfoEnabled()) {
            ObjectMapper mapper = new ObjectMapper();
            logger.info("alarmItem: " + mapper.writeValueAsString((Object)alarmItem) + ", alarmData: " + mapper.writeValueAsString((Object)alarmData) + ", subject: " + emailVo.getSubject());
        }
        emailVo.setHtml(alarmData.getContent());
        emailVo.setTo(mailTo.toArray(new String[mailTo.size()]));
        this.emailService.sendEmail(emailVo);
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.emailAccount = this.buildEmailAccount();
        this.emailService.setEmailAccount(this.emailAccount);
    }
}

