/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.alarm.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.alarmcenter.alarm.Alarm;
import com.xunlei.channel.alarmcenter.alarm.sender.MessageSender;
import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmItemDAO;
import com.xunlei.channel.alarmcenter.dbservice.dao.ContactDAO;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import com.xunlei.channel.alarmcenter.dbservice.pojo.Contact;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AlarmImpl
implements Alarm {
    private static final Logger logger = LoggerFactory.getLogger(AlarmImpl.class);
    @Autowired
    private ContactDAO contactDAO;
    @Autowired
    private AlarmItemDAO alarmItemDAO;
    @Autowired
    private List<MessageSender> messageSenders;

    public AlarmItem getAlarmItem(AlarmData data) {
        AlarmItem alarmItemQuery = new AlarmItem();
        alarmItemQuery.setAlarmId(data.getAlarmId());
        alarmItemQuery.setInUse(Boolean.valueOf(true));
        List alarmItemList = this.alarmItemDAO.findAlarmItem(alarmItemQuery);
        if (alarmItemList == null || alarmItemList.size() == 0) {
            logger.error("alarmId: {} couldn't found corresponding alarmItem", (Object)data.getAlarmId());
        }
        Assert.notNull((Object)alarmItemList, (String)("alarmId: {" + data.getAlarmId() + "} couldn't found corresponding alarmItem"));
        if (alarmItemList.size() > 1) {
            try {
                if (logger.isWarnEnabled()) {
                    logger.warn("alarmId: {} found two corresponding alarmItems: {}", (Object)data.getAlarmId(), (Object)new ObjectMapper().writeValueAsString((Object)alarmItemList));
                }
            }
            catch (JsonProcessingException ignored) {
                // empty catch block
            }
        }
        AlarmItem alarmItem = (AlarmItem)alarmItemList.get(0);
        return alarmItem;
    }

    public List<Contact> getContacts() {
        Contact contact = new Contact();
        contact.setInUse(Boolean.valueOf(true));
        List contactList = this.contactDAO.findContact(contact);
        logger.debug("find contacts: {}", (Object)contactList);
        return contactList;
    }

    @Override
    public boolean alarm(AlarmData data) {
        List<Contact> contacts = this.getContacts();
        Assert.notEmpty(contacts, (String)"contacts must not be empty!");
        Assert.notNull((Object)data, (String)"alarmData must no be null!");
        Assert.hasText((String)data.getContent(), (String)"content must has text!");
        AlarmItem alarmItem = this.getAlarmItem(data);
        boolean success = false;
        for (MessageSender messageSender : this.messageSenders) {
            try {
                success |= messageSender.sendMessage(contacts, alarmItem, data);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("found message sender: {}, send to contacts: {}, result: {}", new Object[]{messageSender, new ObjectMapper().writeValueAsString(contacts), success});
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug(" send to contacts: {}, result: {}", (Object)new ObjectMapper().writeValueAsString(contacts), (Object)success);
            }
            catch (JsonProcessingException ignore) {
                // empty catch block
            }
        }
        return success;
    }
}

