/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.dbservice.dao.impl;

import com.xunlei.channel.alarmcenter.dbservice.dao.ContactDAO;
import com.xunlei.channel.alarmcenter.dbservice.orm.ContactMapper;
import com.xunlei.channel.alarmcenter.dbservice.pojo.Contact;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ContactDAOImpl
implements ContactDAO {
    @Autowired
    private ContactMapper mapper;

    @Override
    @Transactional(readOnly=false)
    public void saveContact(Contact contact) throws DataAccessException {
        Assert.notNull((Object)contact);
        if (contact.getUpdateTime() == null) {
            contact.setUpdateTime(new Date());
        }
        if (contact.getCreateTime() == null) {
            contact.setCreateTime(new Date());
        }
        this.mapper.saveContact(contact);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateContact(Contact contact) throws DataAccessException {
        Assert.notNull((Object)contact);
        Assert.notNull((Object)contact.getId());
        if (contact.getUpdateTime() == null) {
            contact.setUpdateTime(new Date());
        }
        this.mapper.updateContact(contact);
    }

    @Override
    public List<Contact> findContact(Contact contact) throws DataAccessException {
        Assert.notNull((Object)contact);
        return this.mapper.findContact(contact);
    }

    @Override
    public List<Contact> findById(List<Long> list) throws DataAccessException {
        Assert.notNull(list);
        return this.mapper.findById(list);
    }
}

