/**
 * Project: alarmcenter-dbservice
 * File Created at 15-7-1
 * qi
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.alarmcenter.dbservice.pojo;

/**
 * Created by qi<a href="http://xiongyingqi.com">xiongyingqi.com</a> on 2015-07-01 16:03.
 */
public class Contact extends BasePojo{
    /**
     * 姓名
     */
    private String  name;
    /**
     * 邮箱
     */
    private String  email;
    /**
     * 手机
     */
    private String  mobile;
    /**
     * 是否使用
     */
    private Boolean inUse;
    /**
     * 扩展参数，其他参数信息以json串提供，以后可能要适配微信等信息
     */
    private String  extraJson;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Boolean isInUse() {
        return inUse;
    }

    public void setInUse(Boolean inUse) {
        this.inUse = inUse;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof Contact))
            return false;

        Contact contact = (Contact) o;

        if (name != null ? !name.equals(contact.name) : contact.name != null)
            return false;
        if (email != null ? !email.equals(contact.email) : contact.email != null)
            return false;
        if (mobile != null ? !mobile.equals(contact.mobile) : contact.mobile != null)
            return false;
        if (inUse != null ? !inUse.equals(contact.inUse) : contact.inUse != null)
            return false;
        return !(extraJson != null ?
                !extraJson.equals(contact.extraJson) :
                contact.extraJson != null);

    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (mobile != null ? mobile.hashCode() : 0);
        result = 31 * result + (inUse != null ? inUse.hashCode() : 0);
        result = 31 * result + (extraJson != null ? extraJson.hashCode() : 0);
        return result;
    }
}
