/**
 * Project: arlarmcenter-dbservice
 * File Created at 2015年6月9日
 * lizhaog
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.alarmcenter.dbservice.pojo;

/**
 * @author lizhaog
 */
public class AlarmData extends BasePojo {

    private static final long serialVersionUID = 6191900241576446565L;

    /**
     * 预警的群组ID
     */
    private String  groupId;
    /**
     * 具体的预警ID
     */
    private String  alarmId;
    /**
     * 预警内容
     */
    private String  content;
    /**
     * 内容的MD5签名，以此来判断是否相同消息
     */
    private String  signature;
    /**
     * 其他参数信息以json串提供
     */
    private String  extraJson;
    /**
     * 标志该条数据是否已预警
     */
    private Boolean alarmed;

    /**
     * @return the groupId
     */
    public String getGroupId() {
        return groupId;
    }

    /**
     * @param groupId the groupId to set
     */
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    /**
     * @return the alarmId
     */
    public String getAlarmId() {
        return alarmId;
    }

    /**
     * @param alarmId the alarmId to set
     */
    public void setAlarmId(String alarmId) {
        this.alarmId = alarmId;
    }

    /**
     * @return the content
     */
    public String getContent() {
        return content;
    }

    /**
     * @param content the content to set
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * @return the signature
     */
    public String getSignature() {
        return signature;
    }

    /**
     * @param signature the signature to set
     */
    public void setSignature(String signature) {
        this.signature = signature;
    }

    /**
     * @return the extraJson
     */
    public String getExtraJson() {
        return extraJson;
    }

    /**
     * @param extraJson the extraJson to set
     */
    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public Boolean getAlarmed() {
        return alarmed;
    }

    public void setAlarmed(Boolean alarmed) {
        this.alarmed = alarmed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof AlarmData))
            return false;

        AlarmData alarmData = (AlarmData) o;

        if (groupId != null ? !groupId.equals(alarmData.groupId) : alarmData.groupId != null)
            return false;
        if (alarmId != null ? !alarmId.equals(alarmData.alarmId) : alarmData.alarmId != null)
            return false;
        if (content != null ? !content.equals(alarmData.content) : alarmData.content != null)
            return false;
        if (signature != null ?
                !signature.equals(alarmData.signature) :
                alarmData.signature != null)
            return false;
        if (extraJson != null ?
                !extraJson.equals(alarmData.extraJson) :
                alarmData.extraJson != null)
            return false;
        return !(alarmed != null ? !alarmed.equals(alarmData.alarmed) : alarmData.alarmed != null);

    }

    @Override
    public int hashCode() {
        int result = groupId != null ? groupId.hashCode() : 0;
        result = 31 * result + (alarmId != null ? alarmId.hashCode() : 0);
        result = 31 * result + (content != null ? content.hashCode() : 0);
        result = 31 * result + (signature != null ? signature.hashCode() : 0);
        result = 31 * result + (extraJson != null ? extraJson.hashCode() : 0);
        result = 31 * result + (alarmed != null ? alarmed.hashCode() : 0);
        return result;
    }
}
