package com.xunlei.channel.alarmcenter.dbservice.dao.impl;

import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmItemDAO;
import com.xunlei.channel.alarmcenter.dbservice.orm.AlarmItemMapper;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.List;

/**
 * Created by qi<a href="http://xiongyingqi.com">xiongyingqi.com</a> on 2015-07-01 16:24.
 */
@Service
public class AlarmItemDAOImpl implements AlarmItemDAO {
    @Autowired
    private AlarmItemMapper mapper;

    @Transactional(readOnly = false)
    @Override
    public void saveAlarmItem(AlarmItem alarmItem) throws DataAccessException {
        Assert.notNull(alarmItem);
        if(alarmItem.getUpdateTime() == null){
            alarmItem.setUpdateTime(new Date());
        }
        if(alarmItem.getCreateTime() == null){
            alarmItem.setCreateTime(new Date());
        }
        mapper.saveAlarmItem(alarmItem);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateAlarmItem(AlarmItem alarmItem) throws DataAccessException {
        Assert.notNull(alarmItem);
        Assert.notNull(alarmItem.getId());
        if(alarmItem.getUpdateTime() == null){
            alarmItem.setUpdateTime(new Date());
        }
        mapper.updateAlarmItem(alarmItem);
    }

    @Override
    public List<AlarmItem> findAlarmItem(AlarmItem alarmItem) throws DataAccessException {
        Assert.notNull(alarmItem);
        return mapper.findAlarmItem(alarmItem);
    }

}
