/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.alarmcenter.dbservice.dao.impl;

import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmDataDAO;
import com.xunlei.channel.alarmcenter.dbservice.orm.AlarmDataMapper;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AlarmDataDAOImpl
implements AlarmDataDAO {
    private static final Logger logger = LoggerFactory.getLogger(AlarmDataDAOImpl.class);
    @Autowired
    AlarmDataMapper alarmDataMapper;

    @Override
    @Transactional(readOnly=false)
    public void saveAlarmData(AlarmData alarmData) throws DataAccessException {
        Assert.notNull((Object)alarmData);
        if (alarmData.getAlarmed() == null) {
            alarmData.setAlarmed(false);
        }
        if (alarmData.getUpdateTime() == null) {
            alarmData.setUpdateTime(new Date());
        }
        if (alarmData.getCreateTime() == null) {
            alarmData.setCreateTime(new Date());
        }
        this.alarmDataMapper.saveAlarmData(alarmData);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateAlarmData(AlarmData alarmData) throws DataAccessException {
        Assert.notNull((Object)alarmData);
        if (alarmData.getUpdateTime() == null) {
            alarmData.setUpdateTime(new Date());
        }
        if (alarmData.getCreateTime() == null) {
            alarmData.setCreateTime(new Date());
        }
        this.alarmDataMapper.updateAlarmData(alarmData);
    }

    @Override
    public List<AlarmData> findAlarmData(AlarmData alarmData) throws DataAccessException {
        Assert.notNull((Object)alarmData);
        return this.alarmDataMapper.findAlarmData(alarmData);
    }

    @Override
    public List<AlarmData> findAlarmDataByStatus(Boolean alarmed, int limit) throws DataAccessException {
        Assert.notNull((Object)alarmed);
        return this.alarmDataMapper.findAlarmDataByStatus(alarmed, limit);
    }

    @Override
    public void updateAlarmDataStatus(Long[] ids, boolean alarmed) throws DataAccessException {
        Assert.notNull((Object)ids);
        Assert.isTrue((ids.length > 0 ? 1 : 0) != 0);
        this.alarmDataMapper.updateAlarmDataStatus(ids, alarmed);
    }
}

