/**
 * Project: alarmcenter-dbservice
 * File Created at 15-7-1
 * qi
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.alarmcenter.dbservice.pojo;

/**
 * Created by qi<a href="http://xiongyingqi.com">xiongyingqi.com</a> on 2015-07-01 18:02.
 */
public class AlarmItem extends BasePojo {
    /**
     * 预警名称
     */
    private String  name;
    /**
     * 是否可用
     */
    private Boolean inUse;
    /**
     * 预警编号
     */
    private String  alarmId;
    /**
     * 负责人
     */
    private String  owner;
    /**
     * 描述
     */
    private String  description;
    /**
     * 预警策略，json格式
     */
    private String  strategy;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getInUse() {
        return inUse;
    }

    public void setInUse(Boolean inUse) {
        this.inUse = inUse;
    }

    public String getAlarmId() {
        return alarmId;
    }

    public void setAlarmId(String alarmId) {
        this.alarmId = alarmId;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof AlarmItem))
            return false;

        AlarmItem alarmItem = (AlarmItem) o;

        if (name != null ? !name.equals(alarmItem.name) : alarmItem.name != null)
            return false;
        if (inUse != null ? !inUse.equals(alarmItem.inUse) : alarmItem.inUse != null)
            return false;
        if (alarmId != null ? !alarmId.equals(alarmItem.alarmId) : alarmItem.alarmId != null)
            return false;
        if (owner != null ? !owner.equals(alarmItem.owner) : alarmItem.owner != null)
            return false;
        if (description != null ? !description.equals(alarmItem.description) : alarmItem.description
                != null)
            return false;
        return !(strategy != null ?
                !strategy.equals(alarmItem.strategy) :
                alarmItem.strategy != null);

    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (inUse != null ? inUse.hashCode() : 0);
        result = 31 * result + (alarmId != null ? alarmId.hashCode() : 0);
        result = 31 * result + (owner != null ? owner.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (strategy != null ? strategy.hashCode() : 0);
        return result;
    }
}
