package com.xunlei.channel.alarmcenter.dbservice.dao.impl;

import com.xunlei.channel.alarmcenter.dbservice.dao.ContactDAO;
import com.xunlei.channel.alarmcenter.dbservice.orm.ContactMapper;
import com.xunlei.channel.alarmcenter.dbservice.pojo.Contact;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.List;

/**
 * Created by qi<a href="http://xiongyingqi.com">xiongyingqi.com</a> on 2015-07-01 16:24.
 */
@Service
public class ContactDAOImpl implements ContactDAO {
    @Autowired
    private ContactMapper mapper;

    @Transactional(readOnly = false)
    @Override
    public void saveContact(Contact contact) throws DataAccessException {
        Assert.notNull(contact);
        if(contact.getUpdateTime() == null){
            contact.setUpdateTime(new Date());
        }
        if(contact.getCreateTime() == null){
            contact.setCreateTime(new Date());
        }
        mapper.saveContact(contact);
    }

    @Transactional(readOnly = false)
    @Override
    public void updateContact(Contact contact) throws DataAccessException {
        Assert.notNull(contact);
        Assert.notNull(contact.getId());
        if(contact.getUpdateTime() == null){
            contact.setUpdateTime(new Date());
        }
        mapper.updateContact(contact);
    }

    @Override
    public List<Contact> findContact(Contact contact) throws DataAccessException {
        Assert.notNull(contact);
        return mapper.findContact(contact);
    }

}
