/**
 * Project: alarmcenter-dbservice
 * File Created at 2015年6月9日
 * lizhaog
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.alarmcenter.dbservice.dao.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import com.xunlei.channel.alarmcenter.dbservice.dao.AlarmDataDAO;
import com.xunlei.channel.alarmcenter.dbservice.orm.AlarmDataMapper;
import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;

import java.util.Date;
import java.util.List;

/**
 * @author lizhaog
 */
@Service
public class AlarmDataDAOImpl implements AlarmDataDAO {

    private static final Logger logger = LoggerFactory.getLogger(AlarmDataDAOImpl.class);

    @Autowired
    AlarmDataMapper alarmDataMapper;

    @Transactional(readOnly = false)
    public void saveAlarmData(AlarmData alarmData) throws DataAccessException {
        Assert.notNull(alarmData);
        if(alarmData.getAlarmed() == null){
            alarmData.setAlarmed(false);
        }
        if(alarmData.getUpdateTime() == null){
            alarmData.setUpdateTime(new Date());
        }
        if(alarmData.getCreateTime() == null){
            alarmData.setCreateTime(new Date());
        }
        alarmDataMapper.saveAlarmData(alarmData);
    }

    @Transactional(readOnly = false)
    public void updateAlarmData(AlarmData alarmData) throws DataAccessException {
        Assert.notNull(alarmData);
        if(alarmData.getUpdateTime() == null){
            alarmData.setUpdateTime(new Date());
        }
        if(alarmData.getCreateTime() == null){
            alarmData.setCreateTime(new Date());
        }
        alarmDataMapper.updateAlarmData(alarmData);
    }

    @Override
    public List<AlarmData> findAlarmData(AlarmData alarmData) throws DataAccessException {
        Assert.notNull(alarmData);
        return alarmDataMapper.findAlarmData(alarmData);
    }

    @Override
    public List<AlarmData> findAlarmDataByStatus(Boolean alarmed, int limit)
            throws DataAccessException {
        Assert.notNull(alarmed);
        return alarmDataMapper.findAlarmDataByStatus(alarmed, limit);
    }

    @Override
    public void updateAlarmDataStatus(Long[] ids, boolean alarmed) throws DataAccessException {
        Assert.notNull(ids);
        Assert.isTrue(ids.length > 0);
        alarmDataMapper.updateAlarmDataStatus(ids, alarmed);
    }

}
