/**
 * Project: alarmcenter-dbservice
 * File Created at 2015年6月9日
 * lizhaog
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.alarmcenter.dbservice.dao;

import org.springframework.dao.DataAccessException;

import com.xunlei.channel.alarmcenter.dbservice.pojo.AlarmData;

import java.util.List;

/**
 * @author lizhaog
 */
public interface AlarmDataDAO {

    void saveAlarmData(AlarmData alarmData) throws DataAccessException;

    void updateAlarmData(AlarmData alarmData) throws DataAccessException;

    List<AlarmData> findAlarmData(AlarmData alarmData) throws DataAccessException;

    /**
     * 根据状态获取最大数量的预警数据
     * @param alarmed Boolean
     * @param limit 最大数据量
     * @return List<AlarmData>
     * @throws DataAccessException
     */
    List<AlarmData> findAlarmDataByStatus(Boolean alarmed, int limit) throws DataAccessException;

    /**
     * 更新id的状态
     * @param ids Long[]
     * @param alarmed 状态
     * @throws DataAccessException
     */
    void updateAlarmDataStatus(Long[] ids, boolean alarmed) throws DataAccessException;
}
