/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.ccbdudect.util;

import com.xunlei.ccbdudect.util.AuthorizeQueryRespDetails;
import com.xunlei.ccbdudect.util.CCBDudectAuthorizeQueryData;
import com.xunlei.ccbdudect.util.CCBDudectPayQueryData;
import com.xunlei.ccbdudect.util.PayQueryRespDetails;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCBDudectPayUtil {
    private static Logger log = LoggerFactory.getLogger(CCBDudectPayUtil.class);
    public static String ip;
    public static int port;
    public static int socketTimeOut;
    public static String custId;
    public static String userId;
    public static String password;
    public static String payQueryTxCode;
    public static String authorizeQueryTxCode;
    public static String language;
    public static String dexcel;
    public static String norderby;
    public static String page;
    public static String timeoutRespCode;
    public static String branchId;
    public static int se;

    static {
        se = 10;
        CCBDudectPayUtil.init();
    }

    public static void init() {
        ResourceBundle rb = ResourceBundle.getBundle("ccbDudectQuery");
        ip = rb.getString("ip");
        String portStr = rb.getString("port");
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            log.error("parse portStr:{} to int with exception,init port=1234:", new Object[]{portStr, e});
            port = 1234;
        }
        String socketTimeOutStr = rb.getString("socketTimeOut");
        try {
            socketTimeOut = Integer.parseInt(socketTimeOutStr);
            if (socketTimeOut <= 1000) {
                socketTimeOut = 30000;
            }
        }
        catch (Exception e) {
            log.error("parse portStr:{} to int with exception,init port=1234:", new Object[]{portStr, e});
            socketTimeOut = 30000;
        }
        custId = rb.getString("CUST_ID");
        userId = rb.getString("USER_ID");
        password = rb.getString("PASSWORD");
        payQueryTxCode = rb.getString("PAY_QUERY_TX_CODE");
        authorizeQueryTxCode = rb.getString("AUTHORIZE_QUERY_TX_CODE");
        language = rb.getString("LANGUAGE");
        dexcel = rb.getString("DEXCEL");
        norderby = rb.getString("NORDERBY");
        page = rb.getString("PAGE");
        timeoutRespCode = rb.getString("timeoutRespCode");
        branchId = rb.getString("BRANCHID");
        log.info("init ip:{},port:{},socketTimeOut:{},custId:{},userId:{},password:{},payQueryTxCode:{},authorizeQueryTxCode:{},langeuage:{},dexcel:{},norderby:{},page:{},timeoutRespCode:{}", new Object[]{ip, port, socketTimeOut, custId, userId, password, payQueryTxCode, authorizeQueryTxCode, language, dexcel, norderby, page, timeoutRespCode});
        if (CCBDudectPayUtil.isEmptyStr(ip) || CCBDudectPayUtil.isEmptyStr(custId) || CCBDudectPayUtil.isEmptyStr(userId) || CCBDudectPayUtil.isEmptyStr(password) || CCBDudectPayUtil.isEmptyStr(payQueryTxCode) || CCBDudectPayUtil.isEmptyStr(language) || CCBDudectPayUtil.isEmptyStr(dexcel) || CCBDudectPayUtil.isEmptyStr(norderby) || CCBDudectPayUtil.isEmptyStr(page)) {
            log.error("ip/custId/userId/password/txCode/language/dexcel/norderby/page is null,will not query success");
        }
    }

    public static String createPayQueryRequstXml(CCBDudectPayQueryData data) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?><TX>");
        sb.append("<REQUEST_SN>").append(data.getRequestSn()).append("</REQUEST_SN>");
        sb.append("<CUST_ID>").append(data.getCustId()).append("</CUST_ID>");
        sb.append("<USER_ID>").append(data.getUserId()).append("</USER_ID>");
        sb.append("<PASSWORD>").append(data.getPassword()).append("</PASSWORD>");
        sb.append("<TX_CODE>").append(data.getTxCode()).append("</TX_CODE>");
        sb.append("<LANGUAGE>").append(data.getLanguage()).append("</LANGUAGE>");
        sb.append("<TX_INFO>");
        sb.append("<START>").append(data.getStart()).append("</START>");
        sb.append("<STARTHOUR>").append(data.getStartHour()).append("</STARTHOUR>");
        sb.append("<STARTMIN>").append(data.getStartMin()).append("</STARTMIN>");
        sb.append("<END>").append(data.getEnd()).append("</END>");
        sb.append("<ENDHOUR>").append(data.getEndHour()).append("</ENDHOUR>");
        sb.append("<ENDMIN>").append(data.getEndMin()).append("</ENDMIN>");
        sb.append("<KIND>").append(data.getKind()).append("</KIND>");
        sb.append("<ORDER>").append(data.getOrder()).append("</ORDER>");
        sb.append("<ACCOUNT>").append(data.getAccount()).append("</ACCOUNT>");
        sb.append("<DEXCEL>").append(data.getDexcel()).append("</DEXCEL>");
        sb.append("<MONEY>").append(data.getMoney()).append("</MONEY>");
        sb.append("<NORDERBY>").append(data.getNorderby()).append("</NORDERBY>");
        sb.append("<PAGE>").append(data.getPage()).append("</PAGE>");
        sb.append("<POS_CODE>").append(data.getPosCode()).append("</POS_CODE>");
        sb.append("<STATUS>").append(data.getStatus()).append("</STATUS>");
        sb.append("</TX_INFO></TX>");
        return sb.toString();
    }

    public static String createAuthorizeQueryRequstXml(CCBDudectAuthorizeQueryData data) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?><TX>");
        sb.append("<REQUEST_SN>").append(data.getRequestSn()).append("</REQUEST_SN>");
        sb.append("<CUST_ID>").append(data.getCustId()).append("</CUST_ID>");
        sb.append("<USER_ID>").append(data.getUserId()).append("</USER_ID>");
        sb.append("<PASSWORD>").append(data.getPassword()).append("</PASSWORD>");
        sb.append("<TX_CODE>").append(data.getTxCode()).append("</TX_CODE>");
        sb.append("<LANGUAGE>").append(data.getLanguage()).append("</LANGUAGE>");
        sb.append("<TX_INFO>");
        sb.append("<GRANTNUM>").append(data.getAuthId()).append("</GRANTNUM>");
        sb.append("<BRANCHID>").append(data.getBranchId()).append("</BRANCHID>");
        sb.append("</TX_INFO></TX>");
        return sb.toString();
    }

    public static PayQueryRespDetails createPayQueryRespVoFromXml(String respXml) {
        PayQueryRespDetails details = new PayQueryRespDetails();
        try {
            Document doc = DocumentHelper.parseText((String)respXml);
            Element root = doc.getRootElement();
            String requestSn = root.elementText("REQUEST_SN");
            String returnCode = root.elementText("RETURN_CODE");
            String returnMsg = root.elementText("RETURN_MSG");
            details.setRequestSn(requestSn == null ? "" : requestSn);
            details.setReturnCode(returnCode == null ? "" : returnCode);
            details.setReturnMsg(returnMsg == null ? "" : returnMsg);
            Element list = root.element("TX_INFO");
            if (list == null) {
                return details;
            }
            list = list.element("LIST");
            String order = list.elementText("ORDER");
            String paymentMoney = list.elementText("PAYMENT_MONEY");
            String orderStatus = list.elementText("ORDER_STATUS");
            details.setPaymentMoney(paymentMoney == null ? "" : paymentMoney);
            details.setOrder(order == null ? "" : order);
            details.setOrderStatus(orderStatus == null ? "" : orderStatus);
            log.info("createRespVoFromXml:{}", (Object)details);
            return details;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static AuthorizeQueryRespDetails createAuthorizeQueryRespVoFromXml(String respXml) {
        AuthorizeQueryRespDetails details = new AuthorizeQueryRespDetails();
        try {
            Document doc = DocumentHelper.parseText((String)respXml);
            Element root = doc.getRootElement();
            String requestSn = root.elementText("REQUEST_SN");
            String returnCode = root.elementText("RETURN_CODE");
            String returnMsg = root.elementText("RETURN_MSG");
            String custId = root.elementText("CUST_ID");
            details.setRequestSn(requestSn == null ? "" : requestSn);
            details.setReturnCode(returnCode == null ? "" : returnCode);
            details.setReturnMsg(returnMsg == null ? "" : returnMsg);
            details.setCustId(custId == null ? "" : custId);
            Element list = root.element("TX_INFO");
            if (list == null) {
                return details;
            }
            String authId = list.elementText("GRANT_NUM");
            String authDate = list.elementText("AUTH_DATE");
            String customer = list.elementText("CUSTOMER_NAME");
            String payment = list.elementText("SINGLE_TRAN_LIMIT");
            String limit = list.elementText("DAY_TRAN_LIMIT");
            String remark = list.elementText("GRANT_FLAG");
            details.setAuthId(authId == null ? "" : authId);
            details.setAuthDate(authDate == null ? "" : authDate);
            details.setCustomer(customer == null ? "" : customer);
            details.setLimit(limit == null ? "" : limit);
            details.setPayment(payment == null ? "" : payment);
            details.setRemark(remark == null ? "" : remark);
            log.info("createRespVoFromXml:{}", (Object)details);
            return details;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static boolean isEmptyStr(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static synchronized String genRequstSn() {
        StringBuffer requestSn = new StringBuffer("0");
        long currentTime = System.currentTimeMillis();
        requestSn.append(currentTime);
        if (se > 99) {
            se = 10;
        }
        requestSn.append(se);
        ++se;
        return requestSn.toString();
    }
}

