/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.ccbdudect.query;

import com.xunlei.ccbdudect.util.AuthorizeQueryRespDetails;
import com.xunlei.ccbdudect.util.CCBDudectAuthorizeQueryData;
import com.xunlei.ccbdudect.util.CCBDudectPayUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorCCBAuthorizeHandler {
    private static Logger log = LoggerFactory.getLogger(MonitorCCBAuthorizeHandler.class);

    public HashMap<String, String> query(String authId) {
        log.info("MonitorCCBAuthorizeHandler start monitor:authId:{}", new Object[]{authId});
        Socket socket = null;
        String resp = null;
        String requestSn = CCBDudectPayUtil.genRequstSn();
        try {
            try {
                socket = new Socket(CCBDudectPayUtil.ip, CCBDudectPayUtil.port);
                socket.setSoTimeout(CCBDudectPayUtil.socketTimeOut);
                DataOutputStream outToServer = new DataOutputStream(socket.getOutputStream());
                CCBDudectAuthorizeQueryData data = new CCBDudectAuthorizeQueryData();
                data.setRequestSn(requestSn);
                data.setAuthId(authId);
                String request = CCBDudectPayUtil.createAuthorizeQueryRequstXml(data);
                request = new String(request.getBytes(), "GB18030");
                log.info("authId:{} authorize query request:{}", new Object[]{authId, request});
                outToServer.writeBytes(request);
                DataInputStream inputStream = new DataInputStream(socket.getInputStream());
                StringBuffer sb = new StringBuffer();
                do {
                    sb.append((char)inputStream.read());
                } while (!sb.toString().contains("</TX>"));
                resp = new String(sb.toString().getBytes("8859_1"), "gbk");
                log.info("authId:{} authorize query resp:{}", new Object[]{authId, resp});
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                HashMap<String, String> hashMap = this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e2) {
                        log.error("", (Throwable)e2);
                    }
                }
                return hashMap;
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        log.info("authId:{} with query result:{}", new Object[]{authId, resp});
        if ("".equals(resp)) {
            log.info("authId:{} \u67e5\u8be2\u7f51\u7edc\u8d85\u65f6", (Object)authId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        AuthorizeQueryRespDetails respDetails = CCBDudectPayUtil.createAuthorizeQueryRespVoFromXml(resp);
        if (respDetails == null) {
            log.info("authId:{} \u65e0\u6cd5\u4ece\u8fd4\u56de\u503c\u4e2d\u83b7\u53d6\u53c2\u6570\u4fe1\u606f", (Object)authId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        String requestSnResp = respDetails.getRequestSn();
        if (CCBDudectPayUtil.isEmptyStr(requestSn) || !requestSnResp.equals(requestSn)) {
            log.info("authId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8ba2\u5355\u975e\u67e5\u8be2\u8ba2\u5355", (Object)authId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        if (CCBDudectPayUtil.isEmptyStr(respDetails.getReturnCode())) {
            log.info("authId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8fd4\u56de\u7801\u4e3a\u7a7a", (Object)authId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        if (CCBDudectPayUtil.timeoutRespCode != null && CCBDudectPayUtil.timeoutRespCode.contains(respDetails.getReturnCode())) {
            log.info("authId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u8fd4\u56de\u7801\u4e3a\u67e5\u8be2\u5f02\u5e38\u7684\u8fd4\u56de\u7801", (Object)authId);
            return this.getRtnMap("Y", "", "", "\u6838\u67e5\u5f02\u5e38");
        }
        if (!"000000".equals(respDetails.getReturnCode())) {
            log.info("authId:{} \u67e5\u8be2\u5931\u8d25,\u9519\u8bef\u7801\u4e3a\uff1a{},\u9519\u8bef\u4fe1\u606f\u4e3a:{}", new Object[]{authId, respDetails.getReturnCode(), respDetails.getReturnMsg()});
            return this.getRtnMap("N", "N", "", "\u67e5\u8be2\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a" + respDetails.getReturnCode() + ",\u9519\u8bef\u4fe1\u606f\u4e3a:" + respDetails.getReturnMsg());
        }
        String authIdResp = respDetails.getAuthId();
        if (CCBDudectPayUtil.isEmptyStr(authIdResp) || !authIdResp.equals(authId)) {
            log.info("authId:{} \u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u6388\u6743\u7801\u975e\u8bf7\u6c42\u65f6\u7684\u6388\u6743\u7801", (Object)authId);
            return this.getRtnMap("N", "N", "", "\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u6388\u6743");
        }
        log.info("authId:{} \u6388\u6743\u6210\u529f", new Object[]{authId});
        HashMap<String, String> rtnMap = this.getRtnMap("N", "Y", "", "");
        rtnMap.put("authDate", respDetails.getAuthDate());
        rtnMap.put("customer", respDetails.getCustomer());
        rtnMap.put("payment", respDetails.getPayment());
        rtnMap.put("limit", respDetails.getLimit());
        rtnMap.put("remark", respDetails.getRemark());
        return rtnMap;
    }

    private HashMap<String, String> getRtnMap(String timeOut, String checkSuccess, String amount, String msg) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        rtnMap.put("timeOut", timeOut);
        rtnMap.put("checkSuccess", checkSuccess);
        rtnMap.put("amount", amount);
        rtnMap.put("msg", msg);
        return rtnMap;
    }

    public static void main(String[] args) {
        new MonitorCCBAuthorizeHandler().query("13030121008251220000");
    }
}

