/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.cardpay.check;

import com.xunlei.card.facade.IFacade;
import com.xunlei.card.vo.Cardpayed;
import com.xunlei.cardpay.check.CardPayCheckRet;
import com.xunlei.cardpay.check.CardPayRet;
import com.xunlei.cardpay.check.CardQueryRet;
import com.xunlei.payproxy.util.Arith;
import com.xunlei.payproxy.util.Md5Encrypt;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardPayCheck {
    private static final Logger log = Logger.getLogger(CardPayCheck.class);
    private static String QUERY_CARD = "";
    private static String QUERY_PAY = "";
    private static String BIZ_SYS_NO = "";
    private static String BIZ_KEY = "";
    private static SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    static {
        CardPayCheck.init();
    }

    private static void init() {
        ResourceBundle resource = ResourceBundle.getBundle("cardpay");
        QUERY_CARD = resource.getString("query_card");
        QUERY_PAY = resource.getString("query_pay");
        BIZ_SYS_NO = resource.getString("biz_sys_no");
        BIZ_KEY = resource.getString("biz_key");
    }

    public static CardPayCheckRet check(String xunleipayid, String cardno, double orderamt) {
        log.info((Object)("cardpaycheck xunleipayid:" + xunleipayid));
        CardPayCheckRet rtnData = new CardPayCheckRet();
        Cardpayed query = new Cardpayed();
        query.setTradesn(xunleipayid);
        try {
            Cardpayed result = IFacade.INSTANCE.findCardpayed(query);
            if (result == null) {
                rtnData.setStatus("01");
            } else {
                String cardPayedCardNo = result.getCardno();
                if (cardPayedCardNo == null || !cardPayedCardNo.equals(cardno)) {
                    rtnData.setStatus("04");
                    rtnData.setCardno(result.getCardno());
                    return rtnData;
                }
                double sub = Arith.sub((double)result.getPayedvalue(), (double)orderamt);
                if (Math.abs(sub) >= 0.01) {
                    rtnData.setStatus("05");
                    rtnData.setPayedvalue(result.getPayedvalue());
                    return rtnData;
                }
                rtnData.setStatus("02");
            }
        }
        catch (Exception ex) {
            log.info((Object)("\u67e5\u8be2\u70b9\u5361\u72b6\u6001\u51fa\u9519,xunleipayid:" + xunleipayid + "\tmessage:" + ex.getMessage()));
            rtnData.setStatus("03");
        }
        return rtnData;
    }

    public static CardQueryRet queryCard(String cardno) {
        StringBuffer signContent = new StringBuffer();
        signContent.append("bizsysno=").append(BIZ_SYS_NO);
        signContent.append("&").append("cardno=").append(cardno).append(BIZ_KEY);
        String sign = Md5Encrypt.md5((String)signContent.toString());
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("bizsysno", BIZ_SYS_NO));
        nvps.add((NameValuePair)new BasicNameValuePair("cardno", cardno));
        nvps.add((NameValuePair)new BasicNameValuePair("sign", sign));
        log.info((Object)("queryCard url=" + QUERY_CARD));
        log.info((Object)("params=" + signContent.toString() + "&sign=" + sign));
        String retXml = CardPayCheck.query(QUERY_CARD, nvps);
        log.info((Object)("retXml==" + retXml));
        if (retXml == null || "".equals(retXml)) {
            return null;
        }
        Document document = null;
        CardQueryRet cardQueryRet = new CardQueryRet();
        try {
            document = DocumentHelper.parseText((String)retXml);
            Element root = document.getRootElement();
            String is_success = root.element("is_success").getText();
            if ("Y".equals(is_success.trim())) {
                cardQueryRet.setIsSuccess("Y");
                cardQueryRet.setCardno(root.element("cardno").getText());
                cardQueryRet.setPrice(root.element("price").getText());
                cardQueryRet.setEndtime(root.element("endtime").getText());
                cardQueryRet.setCardstatus(root.element("cardstatus").getText());
                cardQueryRet.setUserno(root.element("useno").getText());
                cardQueryRet.setUsetime(root.element("usetime").getText());
            } else {
                cardQueryRet.setIsSuccess("N");
                cardQueryRet.setErrcode(root.element("errcode").getText());
            }
        }
        catch (Exception ex) {
            log.info((Object)("parse retxml:" + retXml + " with exception"));
            log.info((Object)("exception message:" + ex.getMessage()));
            cardQueryRet = null;
            ex.printStackTrace();
        }
        return cardQueryRet;
    }

    public static CardPayRet queryPay(String orderid) {
        StringBuffer signContent = new StringBuffer();
        signContent.append("bizsysno=").append(BIZ_SYS_NO);
        signContent.append("&").append("orderid=").append(orderid).append(BIZ_KEY);
        String sign = Md5Encrypt.md5((String)signContent.toString());
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("bizsysno", BIZ_SYS_NO));
        nvps.add((NameValuePair)new BasicNameValuePair("orderid", orderid));
        nvps.add((NameValuePair)new BasicNameValuePair("sign", sign));
        log.info((Object)("querypay url=" + QUERY_PAY));
        log.info((Object)("params=" + signContent.toString() + "&sign=" + sign));
        String retXml = CardPayCheck.query(QUERY_PAY, nvps);
        log.info((Object)("retXml==" + retXml));
        if (retXml == null || "".equals(retXml) || "null".equals(retXml)) {
            return null;
        }
        Document document = null;
        CardPayRet cardPayRet = new CardPayRet();
        try {
            document = DocumentHelper.parseText((String)retXml);
            Element root = document.getRootElement();
            String is_success = root.element("is_success").getText();
            if ("Y".equals(is_success.trim())) {
                cardPayRet.setIsSuccess("Y");
                cardPayRet.setCardno(root.element("cardno").getText());
                cardPayRet.setOrderId(root.element("orderid").getText());
                cardPayRet.setOrderAmt(Double.valueOf(root.element("orderamt").getText()) / 100.0);
                cardPayRet.setCardpayId(root.element("cardpayid").getText());
                cardPayRet.setCardpayTime(CardPayCheck.getFormatTime(root.element("cardpaytime").getText()));
                cardPayRet.setFareamt(Double.valueOf(root.element("fareamt").getText()) / 100.0);
                cardPayRet.setPayresult(root.element("payresult").getText());
            } else {
                cardPayRet.setIsSuccess("N");
                cardPayRet.setErrcode(root.element("errcode").getText());
            }
        }
        catch (Exception ex) {
            log.info((Object)("parse retxml:" + retXml + " with exception"));
            log.info((Object)("exception message:" + ex.getMessage()));
            cardPayRet = null;
            ex.printStackTrace();
        }
        return cardPayRet;
    }

    private static String query(String url, List<NameValuePair> nvps) {
        HttpEntity httpEntity;
        String retXml;
        block4: {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(url);
            retXml = null;
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            httpEntity = response.getEntity();
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() == 200) break block4;
            return null;
        }
        try {
            if (httpEntity != null) {
                retXml = EntityUtils.toString((HttpEntity)httpEntity);
            }
        }
        catch (Exception ex) {
            log.info((Object)("query with exection:query url=" + url));
            log.info((Object)("exception message:" + ex.getMessage()));
            ex.printStackTrace();
        }
        return retXml;
    }

    public static void main(String[] args) {
        String retXml = "<?xml version='1.0' encoding='UTF-8'?><card><is_success>Y</is_success><cardno>\u70b9\u5361\u5361\u53f7</cardno><price>\u70b9\u5361\u9762\u503c</price><endtime>\u70b9\u5361\u6709\u6548\u671f</endtime><cardstatus>\u70b9\u5361\u72b6\u6001</cardstatus><useno>\u5145\u503c\u5e10\u53f7</useno><usetime>\u5145\u503c\u65f6\u95f4</usetime></card >";
        Document document = null;
        CardQueryRet cardQueryRet = new CardQueryRet();
        try {
            document = DocumentHelper.parseText((String)retXml);
            Element root = document.getRootElement();
            Element result = root.element("card");
            String is_success = root.element("is_success").getText();
            if ("Y".equals(is_success.trim())) {
                System.out.println(is_success);
                cardQueryRet.setIsSuccess("Y");
            } else {
                System.out.println("here");
                cardQueryRet.setIsSuccess("N");
                cardQueryRet.setErrcode(result.elementText("errcode"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getFormatTime(String oldTime) {
        try {
            Date date = sdf1.parse(oldTime);
            String newTime = sdf2.format(date);
            return newTime;
        }
        catch (ParseException e) {
            log.info((Object)("parse with exception,message:" + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }
}

