/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.packet;

import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.packet.BasePacket;
import com.taobao.tair.packet.PacketStreamer;
import com.taobao.tair.packet.ResponseGetGroupPacket;
import com.taobao.tair.packet.ResponseGetItemsPacket;
import com.taobao.tair.packet.ResponseGetPacket;
import com.taobao.tair.packet.ResponseIncDecPacket;
import com.taobao.tair.packet.ResponseQueryInfoPacket;
import com.taobao.tair.packet.ReturnPacket;
import java.nio.ByteBuffer;

public class TairPacketStreamer
implements PacketStreamer {
    private Transcoder transcoder = null;

    public TairPacketStreamer(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    public BasePacket decodePacket(int pcode, byte[] data) {
        BasePacket packet = this.createPacket(pcode);
        if (packet != null) {
            packet.setLen(data.length);
            packet.setByteBuffer(ByteBuffer.wrap(data));
        }
        return packet;
    }

    private BasePacket createPacket(int pcode) {
        BasePacket packet = null;
        switch (pcode) {
            case 101: {
                packet = new ReturnPacket(this.transcoder);
                break;
            }
            case 102: {
                packet = new ResponseGetPacket(this.transcoder);
                break;
            }
            case 105: {
                packet = new ResponseIncDecPacket(this.transcoder);
                break;
            }
            case 1102: {
                packet = new ResponseGetGroupPacket(null);
                break;
            }
            case 1405: {
                packet = new ResponseGetItemsPacket(this.transcoder);
                break;
            }
            case 1106: {
                packet = new ResponseQueryInfoPacket(this.transcoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("unkonw return packet, pcode: " + pcode);
            }
        }
        if (packet != null && packet.getPcode() != pcode) {
            packet = null;
        }
        return packet;
    }
}

