/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.packet;

import com.taobao.tair.DataEntry;
import com.taobao.tair.ResultCode;
import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.packet.BasePacket;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseGetPacket
extends BasePacket {
    protected int configVersion;
    protected List<DataEntry> entryList;
    protected int resultCode;
    protected List<DataEntry> proxiedKeyList;

    public ResponseGetPacket(Transcoder transcoder) {
        super(transcoder);
        this.pcode = 102;
    }

    @Override
    public int encode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean decode() {
        int pc;
        this.configVersion = this.byteBuffer.getInt();
        this.resultCode = this.byteBuffer.getInt();
        int count = this.byteBuffer.getInt();
        int size = 0;
        Object key = null;
        Object value = null;
        this.entryList = new ArrayList<DataEntry>(count);
        for (int i = 0; i < count; ++i) {
            DataEntry de = new DataEntry();
            this.removeMetas();
            de.decodeMeta(this.byteBuffer);
            size = this.byteBuffer.getInt();
            if (size > 0) {
                key = this.transcoder.decode(this.byteBuffer.array(), this.byteBuffer.position(), size);
                this.byteBuffer.position(this.byteBuffer.position() + size);
            }
            de.setKey(key);
            this.removeMetas();
            new DataEntry().decodeMeta(this.byteBuffer);
            size = this.byteBuffer.getInt();
            if (size > 0) {
                try {
                    value = this.transcoder.decode(this.byteBuffer.array(), this.byteBuffer.position(), size);
                }
                catch (Throwable e) {
                    this.resultCode = ResultCode.SERIALIZEERROR.getCode();
                }
                this.byteBuffer.position(this.byteBuffer.position() + size);
            }
            de.setValue(value);
            this.entryList.add(de);
        }
        if (count > 1 && (pc = this.byteBuffer.getInt()) > 0) {
            this.proxiedKeyList = new ArrayList<DataEntry>(pc);
            for (int i = 0; i < pc; ++i) {
                this.removeMetas();
                DataEntry de = new DataEntry();
                de.decodeMeta(this.byteBuffer);
                size = this.byteBuffer.getInt();
                if (size > 0) {
                    this.proxiedKeyList.indexOf(this.transcoder.decode(this.byteBuffer.array(), this.byteBuffer.position(), size));
                }
                this.byteBuffer.position(this.byteBuffer.position() + size);
            }
        }
        return true;
    }

    public List<DataEntry> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(List<DataEntry> entryList) {
        this.entryList = entryList;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    public int getResultCode() {
        return this.resultCode;
    }
}

