/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.packet;

import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.packet.BasePacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseGetGroupPacket
extends BasePacket {
    private int configVersion;
    private int copyCount;
    private int bucketCount;
    private List<Long> serverList;
    private Map<String, String> configMap;
    private Set<Long> aliveNodes;

    public ResponseGetGroupPacket(Transcoder transcoder) {
        super(transcoder);
        this.pcode = 1102;
    }

    @Override
    public int encode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean decode() {
        int i;
        this.serverList = new ArrayList<Long>();
        this.configMap = new HashMap<String, String>();
        this.bucketCount = this.byteBuffer.getInt();
        this.copyCount = this.byteBuffer.getInt();
        this.configVersion = this.byteBuffer.getInt();
        int count = this.byteBuffer.getInt();
        for (i = 0; i < count; ++i) {
            String name = this.readString();
            String value = this.readString();
            this.configMap.put(name, value);
        }
        count = this.byteBuffer.getInt();
        if (count > 0) {
            byte[] b = new byte[count];
            this.byteBuffer.get(b);
            byte[] result = TairUtil.deflate(b);
            ByteBuffer buff = ByteBuffer.wrap(result);
            buff.order(ByteOrder.LITTLE_ENDIAN);
            ArrayList<Long> ss = new ArrayList<Long>();
            boolean valid = false;
            int c = 0;
            while (buff.hasRemaining()) {
                long sid = buff.getLong();
                if (!valid) {
                    valid = sid != 0L;
                }
                ss.add(sid);
                if (++c != this.bucketCount) continue;
                if (valid) {
                    this.serverList.addAll(ss);
                    ss = new ArrayList();
                }
                c = 0;
                valid = false;
            }
        }
        this.aliveNodes = new HashSet<Long>();
        count = this.byteBuffer.getInt();
        for (i = 0; i < count; ++i) {
            this.aliveNodes.add(this.byteBuffer.getLong());
        }
        return true;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    public List<Long> getServerList() {
        return this.serverList;
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public int getCopyCount() {
        return this.copyCount;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public Set<Long> getAliveNodes() {
        return this.aliveNodes;
    }

    public void setAliveNodes(Set<Long> aliveNodes) {
        this.aliveNodes = aliveNodes;
    }
}

