/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.packet;

import com.taobao.tair.comm.Transcoder;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BasePacket {
    protected Exception exception = null;
    protected ByteBuffer byteBuffer = null;
    protected int chid = 0;
    protected int pcode = 0;
    protected int len = 0;
    private BasePacket returnPacket = null;
    private static AtomicInteger globalChid = new AtomicInteger(0);
    protected Transcoder transcoder = null;
    private long startTime = 0L;
    private ReentrantLock lock;
    private Condition cond;

    public BasePacket(Transcoder transcoder) {
        this.transcoder = transcoder;
    }

    public ByteBuffer getByteBuffer() {
        if (this.byteBuffer == null) {
            this.encode();
        }
        return this.byteBuffer;
    }

    protected void writeString(String str) {
        if (str == null) {
            this.byteBuffer.putInt(0);
        } else {
            byte[] b = str.getBytes();
            this.byteBuffer.putInt(b.length + 1);
            this.byteBuffer.put(b);
            this.byteBuffer.put((byte)0);
        }
    }

    protected String readString() {
        int len = this.byteBuffer.getInt();
        if (len <= 1) {
            return "";
        }
        byte[] b = new byte[len];
        this.byteBuffer.get(b);
        return new String(b, 0, len - 1);
    }

    public int encode() {
        return 0;
    }

    public boolean decode() {
        if (this.byteBuffer == null || this.byteBuffer.remaining() < this.len) {
            return false;
        }
        byte[] tmp = new byte[this.len];
        this.byteBuffer.get(tmp);
        return true;
    }

    protected void writePacketBegin(int capacity) {
        this.chid = globalChid.incrementAndGet();
        this.byteBuffer = ByteBuffer.allocate(capacity + 256);
        this.byteBuffer.putInt(1833067604);
        this.byteBuffer.putInt(this.chid);
        this.byteBuffer.putInt(this.pcode);
        this.byteBuffer.putInt(0);
    }

    protected void writePacketEnd() {
        int len = this.byteBuffer.position() - 16;
        this.byteBuffer.putInt(12, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasePacket getReturnPacket(int timeout) {
        if (this.lock == null) {
            return this.returnPacket;
        }
        this.lock.lock();
        try {
            while (this.returnPacket == null) {
                this.cond.await(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
        return this.returnPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturnPacket(BasePacket returnPacket) {
        if (this.lock == null) {
            this.returnPacket = returnPacket;
            return;
        }
        this.lock.lock();
        this.returnPacket = returnPacket;
        try {
            this.cond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = ByteBuffer.allocate(this.len);
        byteBuffer.get(this.byteBuffer.array());
    }

    public int getPcode() {
        return this.pcode;
    }

    public void setPcode(int pcode) {
        this.pcode = pcode;
    }

    public void setChid(int chid) {
        this.chid = chid;
    }

    public int getChid() {
        if (this.chid == 0) {
            this.encode();
        }
        return this.chid;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        return "basepacket: chid=" + this.chid + ", pcode=" + this.pcode + ", len=" + this.len;
    }

    public Exception getException() {
        return this.exception;
    }

    public void initCondition() {
        this.lock = new ReentrantLock();
        this.cond = this.lock.newCondition();
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    protected void removeMetas() {
        this.byteBuffer.get();
        this.byteBuffer.getInt();
        this.byteBuffer.getShort();
    }

    protected void fillMetas() {
        byte[] data = new byte[7];
        this.byteBuffer.put(data);
    }
}

