/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.json;

import com.taobao.tair.json.JSONArray;
import com.taobao.tair.json.JSONValue;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Json {
    private static final int ELEMENT_TYPE_INT = 0;
    private static final int ELEMENT_TYPE_LLONG = 1;
    private static final int ELEMENT_TYPE_DOUBLE = 2;
    private static final int ELEMENT_TYPE_STRING = 3;
    public static final int ELEMENT_TYPE_INVALID = 4;
    private static final String charset = "UTF-8";

    public static byte[] serialize(List<? extends Object> data) {
        int type = -1;
        if (data == null || data.size() == 0 || (type = Json.checkType(data)) < 0) {
            return null;
        }
        String str = JSONValue.toJSONString(data);
        try {
            byte[] bytes = str.getBytes(charset);
            int meta = Json.encodeMeta(data.size(), type);
            ByteBuffer bb = ByteBuffer.allocate(4 + bytes.length);
            bb.putInt(meta);
            bb.put(bytes);
            return bb.array();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static List<? extends Object> deSerialize(byte[] source) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(source);
        int meta = buffer.getInt();
        int type = Json.getType(meta);
        String value = new String(source, 4, source.length - 4, charset);
        switch (type) {
            case 0: {
                ArrayList<Integer> resInts = new ArrayList<Integer>();
                JSONArray arrayInts = (JSONArray)JSONValue.parse(value);
                for (Object object : arrayInts) {
                    resInts.add(Integer.parseInt(object.toString()));
                }
                return resInts;
            }
            case 1: {
                ArrayList<Long> resLongs = new ArrayList<Long>();
                JSONArray arrayLongs = (JSONArray)JSONValue.parse(value);
                for (Object object : arrayLongs) {
                    resLongs.add(Long.parseLong(object.toString()));
                }
                return resLongs;
            }
            case 2: {
                ArrayList<Double> resDoubles = new ArrayList<Double>();
                JSONArray arrayDoubles = (JSONArray)JSONValue.parse(value);
                for (Object object : arrayDoubles) {
                    resDoubles.add(Double.parseDouble(object.toString()));
                }
                return resDoubles;
            }
            case 3: {
                ArrayList<String> results = new ArrayList<String>();
                JSONArray arrayString = (JSONArray)JSONValue.parse(value);
                for (Object object : arrayString) {
                    results.add((String)object);
                }
                return results;
            }
        }
        return null;
    }

    public static int checkType(List<? extends Object> elements) {
        int firstType = -1;
        for (int i = 0; i < elements.size(); ++i) {
            if (i == 0) {
                firstType = Json.checkType(elements.get(i));
                if (firstType >= 0) continue;
                return firstType;
            }
            int type = Json.checkType(elements.get(i));
            if (type >= 0 && type == firstType) continue;
            return -1;
        }
        return firstType;
    }

    private static int checkType(Object element) {
        if (element instanceof Integer) {
            return 0;
        }
        if (element instanceof Long) {
            return 1;
        }
        if (element instanceof Double) {
            return 2;
        }
        if (element instanceof String) {
            return 3;
        }
        return -1;
    }

    private static int encodeMeta(int count, int type) {
        int result = (type & 7) << 16;
        return result |= count & 0xFFFF;
    }

    private static int getCount(int value) {
        return value & 0xFFFF;
    }

    private static int getType(int value) {
        return value >> 16 & 7;
    }
}

