/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.impl;

import com.taobao.tair.comm.ResponseListener;
import com.taobao.tair.comm.TairClient;
import com.taobao.tair.comm.TairClientFactory;
import com.taobao.tair.etc.TairClientException;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.packet.BasePacket;
import com.taobao.tair.packet.PacketStreamer;
import com.taobao.tair.packet.RequestGetGroupPacket;
import com.taobao.tair.packet.RequestQueryInfoPacket;
import com.taobao.tair.packet.ResponseGetGroupPacket;
import com.taobao.tair.packet.ResponseQueryInfoPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigServer
implements ResponseListener {
    private static final Log log = LogFactory.getLog(ConfigServer.class);
    private static final int MURMURHASH_M = 1540483477;
    private String groupName = null;
    private int configVersion = 0;
    private AtomicLong retrieveLastTime = new AtomicLong(0L);
    private int lastConfigServerIndex = 0;
    private static int aliveConfigServerIndex = 0;
    private List<String> configServerList = new ArrayList<String>();
    private List<Long> serverList;
    private PacketStreamer pstream;
    private int bucketCount = 0;
    private int copyCount = 0;
    private Set<Long> aliveNodes;

    public ConfigServer(String groupName, List<String> configServerList, PacketStreamer pstream) {
        this.groupName = groupName;
        this.pstream = pstream;
        for (String host : configServerList) {
            this.configServerList.add(host.trim());
        }
    }

    public long getServer(byte[] keyByte, boolean isRead) {
        long addr = 0L;
        long hash = this.murMurHash(keyByte);
        log.debug((Object)("hashcode: " + hash + ", bucket count: " + this.bucketCount));
        if (this.serverList != null && this.serverList.size() > 0) {
            log.debug((Object)("bucket: " + (hash %= (long)this.bucketCount)));
            long s = this.serverList.get((int)hash);
            log.debug((Object)("oroginal target server: " + TairUtil.idToAddress(s) + " alive server: " + this.aliveNodes));
            if (this.aliveNodes.contains(s)) {
                addr = s;
            }
        }
        if (addr == 0L && isRead) {
            int index;
            int i = 0;
            for (i = 1; i < this.copyCount && (index = (int)hash + i * this.bucketCount) < this.serverList.size(); ++i) {
                long s = this.serverList.get(index);
                log.debug((Object)("read operation try: " + TairUtil.idToAddress(s)));
                if (!this.aliveNodes.contains(s)) continue;
                addr = s;
                break;
            }
        }
        return addr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean retrieveConfigure() {
        this.retrieveLastTime.set(System.currentTimeMillis());
        RequestGetGroupPacket packet = new RequestGetGroupPacket(null);
        packet.setGroupName(this.groupName);
        packet.setConfigVersion(this.configVersion);
        this.lastConfigServerIndex = aliveConfigServerIndex;
        boolean initSuccess = false;
        int i = 0;
        while (i < this.configServerList.size()) {
            block14: {
                block11: {
                    BasePacket returnPacket;
                    String addr;
                    block12: {
                        ResponseGetGroupPacket r;
                        block13: {
                            int index = this.lastConfigServerIndex % this.configServerList.size();
                            addr = this.configServerList.get(index);
                            log.info((Object)("init configs from configserver: " + addr));
                            returnPacket = null;
                            try {
                                TairClient client = TairClientFactory.getInstance().get(addr, 2000, this.pstream);
                                returnPacket = (BasePacket)client.invoke(packet, 2000L);
                            }
                            catch (Exception e) {
                                log.error((Object)("get config failed from: " + addr), (Throwable)e);
                            }
                            if (returnPacket == null || !(returnPacket instanceof ResponseGetGroupPacket)) break block12;
                            r = (ResponseGetGroupPacket)returnPacket;
                            this.configVersion = r.getConfigVersion();
                            this.bucketCount = r.getBucketCount();
                            this.copyCount = r.getCopyCount();
                            this.aliveNodes = r.getAliveNodes();
                            if (this.aliveNodes != null && !this.aliveNodes.isEmpty()) break block13;
                            log.error((Object)"fatal error, no datanode is alive");
                            break block14;
                        }
                        if (log.isInfoEnabled()) {
                            for (Long id : this.aliveNodes) {
                                log.info((Object)("alive datanode: " + TairUtil.idToAddress(id)));
                            }
                        }
                        if (this.bucketCount <= 0) throw new IllegalArgumentException("bucket count or copy count can not be 0");
                        if (this.copyCount <= 0) {
                            throw new IllegalArgumentException("bucket count or copy count can not be 0");
                        }
                        if (r.getServerList() != null && r.getServerList().size() > 0) {
                            this.serverList = r.getServerList();
                            aliveConfigServerIndex = this.lastConfigServerIndex;
                            if (log.isDebugEnabled()) {
                                for (int idx = 0; idx < r.getServerList().size(); ++idx) {
                                    log.debug((Object)("+++ " + idx + " => " + TairUtil.idToAddress(r.getServerList().get(idx))));
                                }
                            }
                            if (this.serverList.size() % this.bucketCount == 0) {
                                log.warn((Object)("configuration inited with version: " + this.configVersion + ", bucket count: " + this.bucketCount + ", copyCount: " + this.copyCount));
                                return true;
                            }
                            log.error((Object)("server size % bucket number != 0, server size: " + this.serverList.size() + ", bucket number" + this.bucketCount + ", copyCount: " + this.copyCount));
                            break block11;
                        } else {
                            log.warn((Object)"server list from config server is null or size is 0");
                        }
                        break block11;
                    }
                    log.error((Object)("retrive from config server " + addr + " failed, result: " + returnPacket));
                }
                ++this.lastConfigServerIndex;
            }
            ++i;
        }
        return initSuccess;
    }

    public Map<String, String> retrieveStat(int qtype, String groupName, long serverId) {
        RequestQueryInfoPacket packet = new RequestQueryInfoPacket(null);
        packet.setGroupName(groupName);
        packet.setQtype(qtype);
        packet.setServerId(serverId);
        Map<String, String> statInfo = null;
        for (int i = 0; i < this.configServerList.size(); ++i) {
            int index = this.lastConfigServerIndex % this.configServerList.size();
            String addr = this.configServerList.get(index);
            BasePacket returnPacket = null;
            try {
                TairClient client = TairClientFactory.getInstance().get(addr, 2000, this.pstream);
                returnPacket = (BasePacket)client.invoke(packet, 2000L);
            }
            catch (Exception e) {
                log.error((Object)("get stat failed " + addr), (Throwable)e);
            }
            if (returnPacket != null && returnPacket instanceof ResponseQueryInfoPacket) {
                ResponseQueryInfoPacket r = (ResponseQueryInfoPacket)returnPacket;
                statInfo = r.getKv();
                break;
            }
            log.error((Object)("retrive stat from config server " + addr + " failed, result: " + returnPacket));
        }
        return statInfo;
    }

    public void checkConfigVersion(int version) {
        if (version == this.configVersion) {
            return;
        }
        if (this.retrieveLastTime.get() > System.currentTimeMillis() - 5000L) {
            log.debug((Object)"last check time is less than 5 seconds, need not sync");
            return;
        }
        this.retrieveLastTime.set(System.currentTimeMillis());
        RequestGetGroupPacket packet = new RequestGetGroupPacket(null);
        packet.setGroupName(this.groupName);
        packet.setConfigVersion(this.configVersion);
        for (int i = 0; i < this.configServerList.size(); ++i) {
            int index = this.lastConfigServerIndex % this.configServerList.size();
            String host = this.configServerList.get(index);
            try {
                TairClient client = TairClientFactory.getInstance().get(host, 2000, this.pstream);
                client.invokeAsync(packet, 2000L, this);
            }
            catch (TairClientException e) {
                log.error((Object)"get client failed", (Throwable)e);
            }
            ++this.lastConfigServerIndex;
        }
    }

    @Override
    public void responseReceived(Object packet) {
        if (packet != null && packet instanceof ResponseGetGroupPacket) {
            ResponseGetGroupPacket r = (ResponseGetGroupPacket)packet;
            r.decode();
            log.warn((Object)("configuration synced, oldversion: " + this.configVersion + ", new verion: " + r.getConfigVersion()));
            this.configVersion = r.getConfigVersion();
            this.aliveNodes = r.getAliveNodes();
            if (this.aliveNodes.isEmpty()) {
                throw new IllegalArgumentException("fatal error, no node is alive");
            }
            for (Long id : this.aliveNodes) {
                log.info((Object)("alive node: " + TairUtil.idToAddress(id)));
            }
            if (r.getServerList() != null && r.getServerList().size() > 0) {
                this.serverList = r.getServerList();
                if (log.isDebugEnabled()) {
                    for (int idx = 0; idx < r.getServerList().size(); ++idx) {
                        log.debug((Object)("+++ " + idx + " => " + TairUtil.idToAddress(r.getServerList().get(idx))));
                    }
                }
            }
        }
    }

    @Override
    public void exceptionCaught(TairClientException exception) {
        log.error((Object)"do async request failed", (Throwable)exception);
    }

    private long murMurHash(byte[] key) {
        int len;
        int h = 0x61 ^ len;
        int index = 0;
        for (len = key.length; len >= 4; len -= 4) {
            int k = key[index] & 0xFF | key[index + 1] << 8 & 0xFF00 | key[index + 2] << 16 & 0xFF0000 | key[index + 3] << 24;
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
            index += 4;
        }
        switch (len) {
            case 3: {
                h ^= key[index + 2] << 16;
            }
            case 2: {
                h ^= key[index + 1] << 8;
            }
            case 1: {
                h ^= key[index];
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return (long)h & 0xFFFFFFFFL;
    }
}

