/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.etc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.InflaterInputStream;

public class TairUtil {
    public static final String HEXES = "0123456789ABCDEF";
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public static void checkMalloc(int size) {
        if (size > 0x100000) {
            throw new IllegalArgumentException("alloc to large byte[], size: " + size);
        }
    }

    public static byte[] deflate(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            bos = new ByteArrayOutputStream();
            try {
                InflaterInputStream gis = new InflaterInputStream(bis);
                byte[] buf = new byte[8192];
                int r = -1;
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                bos = null;
            }
        }
        return bos == null ? null : bos.toByteArray();
    }

    public static String idToAddress(long id) {
        StringBuffer host = new StringBuffer(30);
        host.append(id & 0xFFL).append('.');
        host.append(id >> 8 & 0xFFL).append('.');
        host.append(id >> 16 & 0xFFL).append('.');
        host.append(id >> 24 & 0xFFL);
        int port = (int)(id >> 32 & 0xFFFFL);
        return host.append(":").append(port).toString();
    }

    public static long hostToLong(String host) {
        return TairUtil.hostToLong(host, -1);
    }

    public static String getHost(String address) {
        String[] a;
        String host = null;
        if (address != null && (a = address.split(":")).length >= 2) {
            host = a[0].trim();
        }
        return host;
    }

    public static int getPort(String address) {
        String[] a;
        int port = 0;
        if (address != null && (a = address.split(":")).length >= 2) {
            port = Integer.parseInt(a[1].trim());
        }
        return port;
    }

    public static long hostToLong(String host, int port) {
        if (host == null) {
            return 0L;
        }
        try {
            String[] a = host.split(":");
            if (a.length >= 2) {
                port = Integer.parseInt(a[1].trim());
            }
            if (port == -1) {
                return 0L;
            }
            InetSocketAddress addr = new InetSocketAddress(a[0], port);
            if (addr == null || addr.getAddress() == null || addr.getPort() == 0) {
                return 0L;
            }
            byte[] ip = addr.getAddress().getAddress();
            long address = addr.getPort() & 0xFFFF;
            int ipa = 0;
            ipa |= ip[3] << 24 & 0xFF000000;
            ipa |= ip[2] << 16 & 0xFF0000;
            ipa |= ip[1] << 8 & 0xFF00;
            if ((ipa |= ip[0] & 0xFF) < 0) {
                ++address;
            }
            return (address <<= 32) + (long)ipa;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String toHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF)).append(" ");
        }
        return hex.toString();
    }

    public static String formatDate(int seconds) {
        return dateFormat.format(new Date((long)seconds * 1000L));
    }
}

