/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.comm;

import com.taobao.tair.comm.TairClient;
import com.taobao.tair.comm.TairClientFactory;
import com.taobao.tair.comm.TairResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class TairClientProcessor
extends IoHandlerAdapter {
    private static final Log LOGGER = LogFactory.getLog(TairClientProcessor.class);
    private TairClient client = null;
    private TairClientFactory factory = null;
    private String key = null;

    public void setClient(TairClient client) {
        this.client = client;
    }

    public void setFactory(TairClientFactory factory, String targetUrl) {
        this.factory = factory;
        this.key = targetUrl;
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        TairResponse response = (TairResponse)message;
        Integer requestId = response.getRequestId();
        if (this.client.isCallbackTask(requestId)) {
            this.client.putCallbackResponse(requestId, response.getResponse());
        } else {
            this.client.putResponse(requestId, response.getResponse());
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)"connection exception occured", cause);
        }
        if (!(cause instanceof IOException)) {
            session.close();
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.factory.removeClient(this.key);
    }
}

