/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.comm;

import com.taobao.tair.comm.ResponseCallbackTask;
import com.taobao.tair.comm.ResponseListener;
import com.taobao.tair.comm.TairClientFactory;
import com.taobao.tair.comm.TairResponse;
import com.taobao.tair.etc.TairClientException;
import com.taobao.tair.packet.BasePacket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;

public class TairClient {
    private static final Log LOGGER = LogFactory.getLog(TairClient.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static ConcurrentHashMap<Integer, ResponseCallbackTask> callbackTasks = new ConcurrentHashMap();
    private static long minTimeout = 100L;
    private static ConcurrentHashMap<Integer, ArrayBlockingQueue<Object>> responses = new ConcurrentHashMap();
    private final IoSession session;
    private String key;

    protected TairClient(IoSession session, String key) {
        this.session = session;
        this.key = key;
    }

    public Object invoke(final BasePacket packet, long timeout) throws TairClientException {
        if (isDebugEnabled) {
            LOGGER.debug((Object)("send request [" + packet.getChid() + "],time is:" + System.currentTimeMillis()));
        }
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        responses.put(packet.getChid(), queue);
        ByteBuffer bb = packet.getByteBuffer();
        bb.flip();
        byte[] data = new byte[bb.remaining()];
        bb.get(data);
        WriteFuture writeFuture = this.session.write((Object)data);
        writeFuture.addListener(new IoFutureListener(){

            public void operationComplete(IoFuture future) {
                WriteFuture wfuture = (WriteFuture)future;
                if (wfuture.isWritten()) {
                    return;
                }
                String error = "send message to tair server error [" + packet.getChid() + "], tair server: " + TairClient.this.session.getRemoteAddress() + ", maybe because this connection closed :" + !TairClient.this.session.isConnected();
                LOGGER.warn((Object)error);
                TairResponse response = new TairResponse();
                response.setRequestId(packet.getChid());
                response.setResponse(new TairClientException(error));
                try {
                    TairClient.this.putResponse(packet.getChid(), response.getResponse());
                }
                catch (TairClientException e) {
                    // empty catch block
                }
                if (TairClient.this.session.isConnected()) {
                    TairClient.this.session.close();
                } else {
                    TairClientFactory.getInstance().removeClient(TairClient.this.key);
                }
            }
        });
        Object response = null;
        try {
            response = queue.poll(timeout, TimeUnit.MILLISECONDS);
            if (response == null) {
                throw new TairClientException("tair client invoke timeout,timeout is: " + timeout + ",requestId is: " + packet.getChid());
            }
            if (response instanceof TairClientException) {
                throw (TairClientException)response;
            }
        }
        catch (InterruptedException e) {
            throw new TairClientException("tair client invoke error", e);
        }
        finally {
            responses.remove(packet.getChid());
            queue = null;
        }
        if (isDebugEnabled) {
            LOGGER.debug((Object)("return response [" + packet.getChid() + "],time is:" + System.currentTimeMillis()));
            LOGGER.debug((Object)("current responses size: " + responses.size()));
        }
        if (response instanceof BasePacket) {
            ((BasePacket)response).decode();
        }
        return response;
    }

    public void invokeAsync(final BasePacket packet, long timeout, ResponseListener listener) {
        if (isDebugEnabled) {
            LOGGER.debug((Object)("send request [" + packet.getChid() + "] async,time is:" + System.currentTimeMillis()));
        }
        if (minTimeout > timeout) {
            minTimeout = timeout;
        }
        final ResponseCallbackTask callbackTask = new ResponseCallbackTask(packet.getChid(), listener, timeout);
        callbackTasks.put(packet.getChid(), callbackTask);
        ByteBuffer bb = packet.getByteBuffer();
        bb.flip();
        byte[] data = new byte[bb.remaining()];
        bb.get(data);
        WriteFuture writeFuture = this.session.write((Object)data);
        writeFuture.addListener(new IoFutureListener(){

            public void operationComplete(IoFuture future) {
                WriteFuture wfuture = (WriteFuture)future;
                if (wfuture.isWritten()) {
                    return;
                }
                String error = "send message to tair server error [" + packet.getChid() + "], tair server: " + TairClient.this.session.getRemoteAddress() + ", maybe because this connection closed :" + !TairClient.this.session.isConnected();
                LOGGER.warn((Object)error);
                callbackTask.setResponse(new TairClientException(error));
                if (TairClient.this.session.isConnected()) {
                    TairClient.this.session.close();
                } else {
                    TairClientFactory.getInstance().removeClient(TairClient.this.key);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void putResponse(Integer requestId, Object response) throws TairClientException {
        if (responses.containsKey(requestId)) {
            try {
                ArrayBlockingQueue<Object> queue = responses.get(requestId);
                if (queue != null) {
                    queue.put(response);
                    if (!isDebugEnabled) return;
                    LOGGER.debug((Object)("put response [" + requestId + "],time is:" + System.currentTimeMillis()));
                    return;
                }
                if (!isDebugEnabled) return;
                LOGGER.debug((Object)("give up the response,maybe because timeout,requestId is:" + requestId));
                return;
            }
            catch (InterruptedException e) {
                throw new TairClientException("put response error", e);
            }
        } else {
            if (!isDebugEnabled) return;
            LOGGER.debug((Object)("give up the response,maybe because timeout,requestId is:" + requestId));
        }
    }

    protected boolean isCallbackTask(Integer requestId) {
        return callbackTasks.containsKey(requestId);
    }

    protected void putCallbackResponse(Integer requestId, Object response) throws TairClientException {
        ResponseCallbackTask task = callbackTasks.get(requestId);
        if (task == null) {
            return;
        }
        task.setResponse(response);
    }

    public String toString() {
        if (this.session != null) {
            return this.session.toString();
        }
        return "null session client";
    }

    static {
        new Thread(new CallbackTasksScan()).start();
    }

    static class CallbackTasksScan
    implements Runnable {
        static final long DEFAULT_SLEEPTIME = 10L;
        boolean isRunning = true;
        final TairClientException timeoutException = new TairClientException("receive response timeout");

        CallbackTasksScan() {
        }

        public void run() {
            while (this.isRunning) {
                ArrayList<Integer> removeIds = new ArrayList<Integer>();
                for (Map.Entry entry : callbackTasks.entrySet()) {
                    long currentTime = System.currentTimeMillis();
                    ResponseCallbackTask task = (ResponseCallbackTask)entry.getValue();
                    if (task.getIsDone().get()) {
                        removeIds.add(task.getRequestId());
                        continue;
                    }
                    if (task.getTimeout() >= currentTime) continue;
                    removeIds.add(task.getRequestId());
                    task.setResponse(this.timeoutException);
                }
                for (Integer removeId : removeIds) {
                    callbackTasks.remove(removeId);
                }
                long sleepTime = 10L;
                if (callbackTasks.size() == 0) {
                    sleepTime = minTimeout;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

