/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.comm;

import com.taobao.tair.comm.ResponseListener;
import com.taobao.tair.comm.TairClient;
import com.taobao.tair.comm.TairClientFactory;
import com.taobao.tair.etc.TairClientException;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.packet.BasePacket;
import com.taobao.tair.packet.PacketStreamer;
import com.taobao.tair.packet.RequestCommandCollection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MultiSender {
    private PacketStreamer packetStreamer = null;

    public MultiSender(PacketStreamer packetStreamer) {
        this.packetStreamer = packetStreamer;
    }

    public boolean sendRequest(RequestCommandCollection rcList, int timeout) {
        Map<Long, BasePacket> map = rcList.getRequestCommandMap();
        MultiReceiveListener listener = new MultiReceiveListener(rcList.getResultList());
        int sendCount = 0;
        for (Long addr : map.keySet()) {
            TairClient client = null;
            try {
                client = TairClientFactory.getInstance().get(TairUtil.idToAddress(addr), timeout, this.packetStreamer);
            }
            catch (TairClientException e) {
                // empty catch block
            }
            if (client == null) continue;
            client.invokeAsync(map.get(addr), timeout, listener);
            ++sendCount;
        }
        listener.await(sendCount, timeout);
        return sendCount == listener.doneCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MultiReceiveListener
    implements ResponseListener {
        private List<BasePacket> resultList = null;
        private ReentrantLock lock = null;
        private Condition cond = null;
        private int doneCount = 0;

        public MultiReceiveListener(List<BasePacket> resultList) {
            this.resultList = resultList;
            this.lock = new ReentrantLock();
            this.cond = this.lock.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void responseReceived(Object response) {
            this.lock.lock();
            try {
                this.resultList.add((BasePacket)response);
                ++this.doneCount;
                this.cond.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void exceptionCaught(TairClientException exception) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(int count, int timeout) {
            long t = TimeUnit.MILLISECONDS.toNanos(timeout);
            this.lock.lock();
            try {
                while (this.doneCount < count) {
                    if ((t = this.cond.awaitNanos(t)) > 0L) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
    }
}

