/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair.comm;

import com.taobao.tair.comm.Transcoder;
import com.taobao.tair.etc.TairUtil;
import com.taobao.tair.etc.TranscoderUtil;
import java.util.Date;

public class DefaultTranscoder
implements Transcoder {
    private int compressionThreshold = 8192;
    private String charset = "UTF-8";

    public DefaultTranscoder() {
    }

    public DefaultTranscoder(int compressionThreshold, String charset) {
        if (compressionThreshold > 0) {
            this.compressionThreshold = compressionThreshold;
        }
        if (charset != null) {
            this.charset = charset;
        }
    }

    public byte[] encode(Object object) {
        int i;
        if (object == null) {
            throw new IllegalArgumentException("key,value can not be null");
        }
        byte[] b = null;
        int flag = 0;
        if (object instanceof String) {
            b = TranscoderUtil.encodeString((String)object, this.charset);
            flag = 2;
        } else if (object instanceof Long) {
            b = TranscoderUtil.encodeLong((Long)object);
            flag = 4;
        } else if (object instanceof Integer) {
            b = TranscoderUtil.encodeInt((Integer)object);
            flag = 1;
        } else if (object instanceof Boolean) {
            b = TranscoderUtil.encodeBoolean((Boolean)object);
            flag = 3;
        } else if (object instanceof Date) {
            b = TranscoderUtil.encodeLong(((Date)object).getTime());
            flag = 5;
        } else if (object instanceof Byte) {
            b = TranscoderUtil.encodeByte((Byte)object);
            flag = 6;
        } else if (object instanceof Float) {
            b = TranscoderUtil.encodeInt(Float.floatToRawIntBits(((Float)object).floatValue()));
            flag = 7;
        } else if (object instanceof Double) {
            b = TranscoderUtil.encodeLong(Double.doubleToRawLongBits((Double)object));
            flag = 8;
        } else if (object instanceof byte[]) {
            b = (byte[])object;
            flag = 9;
        } else {
            b = TranscoderUtil.serialize(object);
            flag = 10;
        }
        flag = (short)(flag << 1);
        if (b.length > this.compressionThreshold) {
            b = TranscoderUtil.compress(b);
            flag = (short)(flag + 1);
        }
        TairUtil.checkMalloc(b.length + 2);
        byte[] result = new byte[b.length + 2];
        byte[] fg = new byte[2];
        fg[1] = (byte)(flag & 0xFF);
        fg[0] = (byte)(flag >> 8 & 0xFF);
        for (i = 0; i < 2; ++i) {
            result[i] = fg[i];
        }
        for (i = 0; i < b.length; ++i) {
            result[i + 2] = b[i];
        }
        return result;
    }

    public Object decode(byte[] data) {
        return this.decode(data, 0, data.length);
    }

    public Object decode(byte[] data, int offset, int size) {
        TairUtil.checkMalloc(size - 2);
        byte[] vb = new byte[size - 2];
        System.arraycopy(data, offset + 2, vb, 0, size - 2);
        Object obj = null;
        int flags = 0;
        for (int i = 0; i < 2; ++i) {
            int b = data[offset + i];
            flags = flags << 8 | (b < 0 ? 256 + b : b);
        }
        if (flags & true) {
            vb = TranscoderUtil.decompress(vb);
        }
        int type = flags >> 1 & 0xF;
        switch (type) {
            case 1: {
                obj = TranscoderUtil.decodeInt(vb);
                break;
            }
            case 2: {
                obj = TranscoderUtil.decodeString(vb, this.charset);
                break;
            }
            case 3: {
                obj = TranscoderUtil.decodeBoolean(vb);
                break;
            }
            case 4: {
                obj = TranscoderUtil.decodeLong(vb);
                break;
            }
            case 5: {
                Long time = TranscoderUtil.decodeLong(vb);
                obj = new Date(time);
                break;
            }
            case 6: {
                obj = TranscoderUtil.decodeByte(vb);
                break;
            }
            case 7: {
                Integer f = TranscoderUtil.decodeInt(vb);
                obj = new Float(Float.intBitsToFloat(f));
                break;
            }
            case 8: {
                Long l = TranscoderUtil.decodeLong(vb);
                obj = new Double(Double.longBitsToDouble(l));
                break;
            }
            case 9: {
                obj = vb;
                break;
            }
            case 10: {
                obj = TranscoderUtil.deserialize(vb);
                break;
            }
            case 11: {
                int rv = 0;
                int bits = 0;
                for (int n : vb) {
                    rv |= (n < 0 ? 256 + n : n) << bits;
                    bits += 8;
                }
                obj = rv;
                break;
            }
            default: {
                throw new RuntimeException("unknow serialize flag: " + type);
            }
        }
        return obj;
    }
}

